/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.dynamicconfig;

import com.hazelcast.internal.dynamicconfig.ConfigUpdateResult;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.dynamicconfig.ConfigPatch;
import com.hazelcast.webmonitor.service.dynamicconfig.ConfigUpdateTriggeredEvent;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.UUID;
import lombok.Generated;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationUpdateService {
    private final OperationDispatcher dispatcher;
    private final MemberConfigService memberConfigService;
    private final ApplicationEventPublisher eventPublisher;

    public UUID startUpdateProcess(String cluster, ConfigPatch configPatch) {
        UUID configUpdateProcessId = (UUID)this.dispatcher.executeOnCluster(cluster, client -> client.startConfigurationUpdate(configPatch.getText()), exc -> "Failed to start configuration update process on cluster " + cluster);
        this.eventPublisher.publishEvent((Object)ConfigUpdateTriggeredEvent.INSTANCE);
        return configUpdateProcessId;
    }

    public ConfigUpdateResult preview(String cluster, ConfigPatch configPatch) {
        MemberConfig originalConfig = (MemberConfig)this.memberConfigService.getRandomConfigFromCluster(cluster).orElseThrow(() -> new NoClusterApiException(cluster));
        return configPatch.previewOn(originalConfig);
    }

    @ConstructorProperties(value={"dispatcher", "memberConfigService", "eventPublisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConfigurationUpdateService(OperationDispatcher dispatcher, MemberConfigService memberConfigService, ApplicationEventPublisher eventPublisher) {
        this.dispatcher = dispatcher;
        this.memberConfigService = memberConfigService;
        this.eventPublisher = eventPublisher;
    }
}

