/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.client_filtering;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingReadWriteLock
extends ReentrantReadWriteLock {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingReadWriteLock.class);
    private static final int TIMEOUT = 10;
    private final String cluster;

    public boolean acquireWriteLock() {
        try {
            boolean acquired = this.writeLock().tryLock(10L, TimeUnit.SECONDS);
            if (!acquired) {
                Thread ownerThread = this.getOwner();
                log.warn("Can't acquire lock for cluster {}. Lock is held by thread {}.\nRead locks count {}. \nStackTrace: {} \nCurrent StackTrace: {}", new Object[]{this.cluster, ownerThread, this.getReadLockCount(), ownerThread.getStackTrace(), Thread.currentThread().getStackTrace()});
            } else {
                log.debug("Lock for cluster {} is acquired by thread {} \nCurrent StackTrace: {}", new Object[]{this.cluster, Thread.currentThread(), Thread.currentThread().getStackTrace()});
            }
            return acquired;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseWriteLock() {
        log.debug("Lock for cluster {} is released by thread {} \nCurrent StackTrace: {}", new Object[]{this.cluster, Thread.currentThread(), Thread.currentThread().getStackTrace()});
        this.writeLock().unlock();
    }

    @ConstructorProperties(value={"cluster"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LoggingReadWriteLock(String cluster) {
        this.cluster = cluster;
    }
}

