/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.ScriptDTO;
import com.hazelcast.webmonitor.controller.exception.ScriptNotFoundException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.model.sql.ScriptModel;
import com.hazelcast.webmonitor.repositories.sql.ScriptDAO;
import com.hazelcast.webmonitor.utils.StringUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScriptManager {
    private final ScriptDAO scriptDAO;

    @Autowired
    public ScriptManager(ScriptDAO scriptDAO) {
        this.scriptDAO = scriptDAO;
    }

    public void saveScript(String userName, ScriptDTO dto) {
        if (!StringUtil.isAlphanumericWithDashAndUnderscore((String)dto.getName())) {
            throw new ValidationFailedApiException("Script name may only contain alpha-numeric characters, underscores and dashes.");
        }
        ScriptModel script = new ScriptModel(userName, dto.getName(), dto.getLanguage(), dto.getCode());
        this.scriptDAO.insertOrUpdate(script);
    }

    public ScriptModel getScript(String userName, String name) {
        return (ScriptModel)this.scriptDAO.findByUsernameAndName(userName, name).orElseThrow(() -> new ScriptNotFoundException(userName, name));
    }

    public void deleteScript(String userName, String name) {
        this.scriptDAO.delete(userName, name);
    }

    public List<String> getScriptNames(String userName) {
        return this.scriptDAO.findNamesByUsername(userName);
    }
}

