/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MembersJoinedEvent;
import com.hazelcast.webmonitor.service.client.MCClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ClusterMemberLimitNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMemberLimitNotifier.class);
    private final MCClientManager mcClientManager;
    private final LicenseManager licenseManager;

    public ClusterMemberLimitNotifier(MCClientManager mcClientManager, LicenseManager licenseManager) {
        this.mcClientManager = mcClientManager;
        this.licenseManager = licenseManager;
    }

    @EventListener
    public void onMemberJoined(MembersJoinedEvent event) {
        int numberOfMembers;
        String cluster = event.getCluster();
        if (this.licenseManager.isAboveMemberLimit(cluster, numberOfMembers = this.getNumberOfMembers(cluster))) {
            if (!this.licenseManager.hasValidLicense()) {
                LOGGER.warn(" Cluster {} has more than {} members ({}). Receiving metrics for it has\n been blocked. You need to configure a valid license on Management\n Center to continue receiving metrics for it.\n", new Object[]{cluster, 3, numberOfMembers});
            } else {
                LOGGER.warn("   Number of members ({}) in cluster {} exceeds the number of members ({})\n   licensed in the Management License key.\n   You need to configure a valid license on Cluster\n    to continue receiving metrics for it.\n", new Object[]{numberOfMembers, 3, cluster});
            }
        }
    }

    private int getNumberOfMembers(String cluster) {
        MCClient client = this.mcClientManager.clientFor(cluster);
        return client.getHzClient().getCluster().getMembers().size();
    }
}

