/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlScalar;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClientConfigSanitizer {
    public String sanitizeXmlConfig(String clientConfig) {
        ClientConfig parsedConfig = new XmlClientConfigBuilder((InputStream)new ByteArrayInputStream(clientConfig.getBytes(StandardCharsets.UTF_8))).build();
        ClientSecurityConfig securityConfig = parsedConfig.getSecurityConfig();
        UsernamePasswordIdentityConfig userPassConfig = securityConfig.getUsernamePasswordIdentityConfig();
        TokenIdentityConfig tokenIdentityConfig = securityConfig.getTokenIdentityConfig();
        if (userPassConfig == null && tokenIdentityConfig == null) {
            return clientConfig;
        }
        if (userPassConfig != null) {
            clientConfig = clientConfig.replace(userPassConfig.getPassword(), "****");
        }
        if (tokenIdentityConfig != null) {
            if (tokenIdentityConfig.getEncoding() == TokenEncoding.BASE64) {
                clientConfig = clientConfig.replace(tokenIdentityConfig.getTokenEncoded(), "****");
            } else if (tokenIdentityConfig.getEncoding() == TokenEncoding.NONE) {
                clientConfig = clientConfig.replace(new String(tokenIdentityConfig.getToken(), StandardCharsets.UTF_8), "****");
            }
        }
        return clientConfig;
    }

    public String sanitizeYamlConfig(String clientConfig) {
        YamlMapping yamlRoot = (YamlMapping)YamlLoader.load((String)clientConfig);
        String password = ClientConfigSanitizer.getPassword((YamlMapping)yamlRoot);
        String token = ClientConfigSanitizer.getToken((YamlMapping)yamlRoot);
        if (password != null) {
            clientConfig = clientConfig.replace(password, "****");
        }
        if (token != null) {
            clientConfig = clientConfig.replace(token, "****");
        }
        return clientConfig;
    }

    private static String getPassword(YamlMapping yamlRoot) {
        return Optional.ofNullable(yamlRoot).map(it -> it.childAsMapping("hazelcast-client")).map(it -> it.childAsMapping("security")).map(it -> it.childAsMapping("username-password")).map(it -> it.childAsScalar("password")).map(YamlScalar::nodeValue).map(Object::toString).orElse(null);
    }

    private static String getToken(YamlMapping yamlRoot) {
        return Optional.ofNullable(yamlRoot).map(it -> it.childAsMapping("hazelcast-client")).map(it -> it.childAsMapping("security")).map(it -> it.childAsMapping("token")).map(it -> it.childAsScalar("value")).map(YamlScalar::nodeValue).map(Object::toString).orElse(null);
    }
}

