/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.collect.Maps;
import com.hazelcast.config.Config;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.internal.management.dto.CPMemberDTO;
import com.hazelcast.webmonitor.controller.dto.CPSubsystemMemberDTO;
import com.hazelcast.webmonitor.controller.dto.CPSubsystemStatusDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSubsystemMetricsDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.service.CPStatsRegistry;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.MemberStateReceivedEvent;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class CPSubsystemManager {
    private static final int CP_UUID_MAX_CACHE_SIZE = 1000;
    private final StateManager stateManager;
    private final MemberManager memberManager;
    private final CPStatsRegistry cpStatsRegistry;
    private final OperationDispatcher dispatcher;
    private final Cache<String, String> cpUuidToAddressCache = Caffeine.newBuilder().maximumSize(1000L).build();

    @EventListener
    public void memberStateReceived(MemberStateReceivedEvent event) {
        MemberState memberState = event.getState().getMemberState();
        String cpMemberUuid = memberState.getCpMemberUuid();
        if (cpMemberUuid != null) {
            this.cpUuidToAddressCache.put((Object)cpMemberUuid, (Object)memberState.getAddress());
        }
    }

    public CPSubsystemStatusDTO getStatus(String cluster) {
        AllState clusterState = this.getClusterState(cluster);
        int reachableCPMembersCount = clusterState.getCPMemberUuids().size();
        boolean isCPDataStructurePresent = this.cpStatsRegistry.isAnyCPDataStructurePresent(cluster);
        return this.memberManager.getAllMemberConfigs(cluster).values().stream().findAny().map(MemberConfig::toEffectiveConfig).map(Config::getCPSubsystemConfig).map(CPSubsystemConfig::getCPMemberCount).map(cpMembersCount -> CPSubsystemStatusDTO.fromStats((int)cpMembersCount, (int)reachableCPMembersCount, (boolean)isCPDataStructurePresent)).orElseGet(CPSubsystemStatusDTO::unknown);
    }

    public List<CPSubsystemMemberDTO> getCPMembers(String cluster) {
        List cpMembers;
        if (this.allMembersParticipateInCPSubsystem(cluster)) {
            cpMembers = (List)this.dispatcher.executeOnCluster(cluster, MCClient::getCPMembers, e -> String.format("Failed to fetch list of CP Subsystem members for cluster %s", cluster));
        } else {
            Collection lists = this.dispatcher.executeOnAllMembers(cluster, (client, member) -> client.getCPMembers(), (member, e) -> null);
            cpMembers = lists.stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new OperationFailedApiException(String.format("Failed to fetch list of CP Subsystem members for cluster %s", cluster)));
        }
        return cpMembers.stream().map(CPMemberDTO::getCPUuid).map(UUID::toString).map(cpUuidString -> new CPSubsystemMemberDTO(cpUuidString, (String)this.cpUuidToAddressCache.get(cpUuidString, key -> "unknown"))).toList();
    }

    private boolean allMembersParticipateInCPSubsystem(String cluster) {
        AllState state = this.getClusterState(cluster);
        return state.getMembers().size() == state.getCPMemberUuids().size();
    }

    public void promoteToCPMember(String cluster, String memberAddress) {
        this.dispatcher.executeOnMember(MemberIdentifier.of((String)cluster, (String)memberAddress), MCClient::promoteToCPMember, e -> String.format("Failed to promote member %s to CP Subsystem for cluster %s", memberAddress, cluster));
    }

    public void removeCPMember(String cluster, UUID cpMemberUuid) {
        this.dispatcher.executeOnCluster(cluster, mcs -> mcs.removeCPMember(cpMemberUuid), e -> String.format("Failed to remove member with UUID %s from CP Subsystem for cluster %s", cpMemberUuid, cluster));
    }

    public void resetCPSubsystem(String cluster) {
        this.dispatcher.executeOnCluster(cluster, MCClient::resetCPSubsystem, e -> String.format("Failed to reset CP Subsystem for cluster %s", cluster));
    }

    public void terminateCPSession(String cluster, String groupName, long sessionId) {
        boolean result = (Boolean)this.dispatcher.executeOnCluster(cluster, mcc -> mcc.forceCloseCPSession(groupName, sessionId), e -> String.format("Failed to terminate cp session in group %s with id %d: %s", groupName, sessionId, e.getMessage()));
        if (result) {
            this.cpStatsRegistry.removeCPSessionFromCache(cluster, groupName, sessionId);
        }
    }

    public Collection<CPSubsystemMetricsDTO> getSubsystemMetrics(String cluster) {
        Set cpMembers = this.getCpMemberAddresses(cluster);
        return this.cpStatsRegistry.getCpSubsystemStats(cluster).values().stream().filter(cpSubsystemMetricsDTO -> cpMembers.contains(cpSubsystemMetricsDTO.getMember())).toList();
    }

    public Collection<CPGroupMetricsDTO> getGroupMetrics(String cluster) {
        Set cpMembers = this.getCpMemberAddresses(cluster);
        List<CPGroupMetricsDTO> copyKnownGroups = this.cpStatsRegistry.getKnownGroups(cluster).values().stream().map(it -> it.toBuilder().members((Map)Maps.newHashMap((Map)it.getMembers())).build()).toList();
        copyKnownGroups.forEach(it -> it.getMembers().keySet().removeIf(memberAddress -> !cpMembers.contains(memberAddress)));
        return copyKnownGroups;
    }

    private Set<String> getCpMemberAddresses(String cluster) {
        return this.getCPMembers(cluster).stream().map(CPSubsystemMemberDTO::getAddress).collect(Collectors.toSet());
    }

    private AllState getClusterState(String cluster) {
        AllState clusterState = this.stateManager.getLatestState(cluster);
        if (clusterState == null) {
            throw new NoClusterApiException(cluster);
        }
        return clusterState;
    }

    @ConstructorProperties(value={"stateManager", "memberManager", "cpStatsRegistry", "dispatcher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CPSubsystemManager(StateManager stateManager, MemberManager memberManager, CPStatsRegistry cpStatsRegistry, OperationDispatcher dispatcher) {
        this.stateManager = stateManager;
        this.memberManager = memberManager;
        this.cpStatsRegistry = cpStatsRegistry;
        this.dispatcher = dispatcher;
    }
}

