/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.webmonitor.metrics.TagsBuilder;
import com.hazelcast.webmonitor.prometheus.PrometheusEntry;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricsProvider;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.LicenseManager;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;

@EnableScheduling
class LicenseDetailProvider
implements PrometheusMetricsProvider {
    static final String UNIT_TAG_VALUE = "TIME";
    static final String METRIC_NAME = "license_expiration";
    static final String LICENSE_TYPE_TAG = "license_type";
    static final String LICENSE_EXPIRATION_TIME_TAG = "expiration";
    static final String PLATFORM_LICENSE = "PLATFORM";
    static final String MANAGEMENT_CENTER_LICENSE = "MANAGEMENT_CENTER";
    private static final int TTL_IN_SECONDS = 10;
    private final Cache<PrometheusEntry.Key, PrometheusEntry.Value> results;
    private final ClusterManager clusterManager;
    private final LicenseManager licenseManager;
    private final Clock clock;

    LicenseDetailProvider(ClusterManager clusterManager, LicenseManager licenseManager, Clock clock) {
        this.clusterManager = clusterManager;
        this.licenseManager = licenseManager;
        this.clock = clock;
        this.results = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    }

    public Set<Map.Entry<PrometheusEntry.Key, PrometheusEntry.Value>> getResults() {
        return this.results.asMap().entrySet();
    }

    @Scheduled(fixedRate=60L, initialDelay=10L, timeUnit=TimeUnit.SECONDS)
    void updateResults() {
        this.tryAddClusterLicenseExpiration();
        this.tryAddMcLicenseExpiration();
    }

    private void tryAddClusterLicenseExpiration() {
        this.clusterManager.getAllClusterLicenseExpirations().forEach((k, v) -> {
            Map tags = TagsBuilder.tagsBuilder().with(LICENSE_TYPE_TAG, PLATFORM_LICENSE).with("mc_cluster", k).with(LICENSE_EXPIRATION_TIME_TAG, String.valueOf(Instant.ofEpochMilli(v))).buildStringMap();
            this.results.put((Object)new PrometheusEntry.Key(METRIC_NAME, tags, UNIT_TAG_VALUE), (Object)new PrometheusEntry.Value(this.clock.currentTimeMillis(), (double)v.longValue()));
        });
    }

    private void tryAddMcLicenseExpiration() {
        long mcLicenseExpirationDate = this.licenseManager.getLicenseExpirationDate();
        if (mcLicenseExpirationDate == -1L) {
            return;
        }
        Map tags = TagsBuilder.tagsBuilder().with(LICENSE_TYPE_TAG, MANAGEMENT_CENTER_LICENSE).with(LICENSE_EXPIRATION_TIME_TAG, String.valueOf(Instant.ofEpochMilli(mcLicenseExpirationDate))).buildStringMap();
        this.results.put((Object)new PrometheusEntry.Key(METRIC_NAME, tags, UNIT_TAG_VALUE), (Object)new PrometheusEntry.Value(this.clock.currentTimeMillis(), (double)mcLicenseExpirationDate));
    }
}

