/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.prometheus.PrometheusExporterConfigurationProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.Servlet;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.servlet.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;

class ExporterJettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Ordered {
    private final PrometheusExporterConfigurationProperties prometheusExporterProperties;
    private final PrometheusExporter prometheusExporter;

    public int getOrder() {
        return 101;
    }

    public void customize(JettyServletWebServerFactory factory) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            int serverPort = factory.getPort();
            int prometheusExporterPort = Optional.ofNullable(this.prometheusExporterProperties.getPort()).orElse(serverPort);
            if (prometheusExporterPort != serverPort) {
                ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
                connector.setPort(prometheusExporterPort);
                connector.setName("Prometheus");
                server.addConnector((Connector)connector);
                ServletContextHandler prometheusContextHandler = new ServletContextHandler("/", 0);
                prometheusContextHandler.addServlet(new ServletHolder((Servlet)new /* Unavailable Anonymous Inner Class!! */), "/metrics");
                prometheusContextHandler.setVirtualHosts(List.of("@Prometheus"));
                ContextHandlerCollection handlerList = new ContextHandlerCollection(new ContextHandler[0]);
                handlerList.addHandler((Handler)prometheusContextHandler);
                for (Handler handler : server.getHandlers()) {
                    handlerList.addHandler(handler);
                }
                server.setHandler((Handler)handlerList);
            }
        }});
    }

    @ConstructorProperties(value={"prometheusExporterProperties", "prometheusExporter"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ExporterJettyWebServerFactoryCustomizer(PrometheusExporterConfigurationProperties prometheusExporterProperties, PrometheusExporter prometheusExporter) {
        this.prometheusExporterProperties = prometheusExporterProperties;
        this.prometheusExporter = prometheusExporter;
    }
}

