/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.notify;

import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.notify.NotifierImpl;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongSupplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class NotifierImpl
implements Notifier {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final ConcurrentMap<String, Pinboard> incidentsByCluster = new ConcurrentHashMap();
    private final Queue<Notifier.Status> statuses = new ConcurrentLinkedQueue();
    private final LongSupplier clock;

    @Autowired
    public NotifierImpl() {
        this(System::currentTimeMillis);
    }

    public NotifierImpl(LongSupplier clock) {
        this.clock = clock;
    }

    public void signal(@Nonnull Note note) {
        Objects.requireNonNull(note);
        this.notesFor(note.cluster).pin(note, this.clock.getAsLong());
    }

    public void register(Notifier.Status status) {
        this.statuses.add(status);
    }

    public Note[] notes(@Nonnull String cluster) {
        Objects.requireNonNull(cluster);
        EnumMap covered = new EnumMap(Note.Matter.class);
        ArrayList<Note> uniqueNotes = new ArrayList<Note>();
        long moment = this.clock.getAsLong();
        NotifierImpl.addUnique((Note[])this.notesFor(cluster).relevantAt(moment), uniqueNotes, covered);
        if (!"*".equals(cluster)) {
            NotifierImpl.addUnique((Note[])this.notesFor("*").relevantAt(moment), uniqueNotes, covered);
        }
        for (Notifier.Status s : this.statuses) {
            Note note = s.check(cluster);
            if (!NotifierImpl.isUnique((Note)note, covered)) continue;
            uniqueNotes.add(note);
        }
        Note[] res = new Note[uniqueNotes.size()];
        int i = res.length - 1;
        for (Note n : uniqueNotes) {
            res[i--] = n;
        }
        return res;
    }

    public void clear(@Nonnull String cluster) {
        Objects.requireNonNull(cluster);
        this.incidentsByCluster.remove(cluster);
    }

    private static void addUnique(Note[] notes, List<Note> uniqueNotes, EnumMap<Note.Matter, Set<String>> covered) {
        for (int i = notes.length - 1; i >= 0; --i) {
            if (!NotifierImpl.isUnique((Note)notes[i], covered)) continue;
            uniqueNotes.add(notes[i]);
        }
    }

    private static boolean isUnique(Note note, EnumMap<Note.Matter, Set<String>> covered) {
        return note != null && covered.computeIfAbsent(note.matter, key -> new HashSet()).add(note.cluster);
    }

    private Pinboard notesFor(String cluster) {
        return this.incidentsByCluster.computeIfAbsent(cluster, key -> new Pinboard(16));
    }
}

