/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model.hz.req.state;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class Version
implements Comparable<Version> {
    private byte major;
    private byte minor;
    private byte patch;
    private String qualifier;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?(-\\w+(?:-\\d+)?)?(-SNAPSHOT)?$");

    private static String[] tokenizeVersionString(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] tokens = new String[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                tokens[i] = matcher.group(i + 1);
            }
            return tokens;
        }
        return new String[0];
    }

    public Version() {
    }

    public Version(int major, int minor, int patch) {
        this.major = (byte)major;
        this.minor = (byte)minor;
        this.patch = (byte)patch;
    }

    public Version(String version) {
        String[] tokens = Version.tokenizeVersionString((String)version);
        if (tokens.length < 2) {
            throw new IllegalArgumentException("Version string [" + version + "] is not in the expected format.");
        }
        this.major = Byte.parseByte(tokens[0]);
        this.minor = Byte.parseByte(tokens[1]);
        if (tokens.length > 3 && tokens[3] != null) {
            this.patch = Byte.parseByte(tokens[3]);
        }
        if (tokens.length > 4 && tokens[4] != null) {
            this.qualifier = tokens[4];
        }
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public byte getPatch() {
        return this.patch;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean isGreaterOrEqual(Version version) {
        return this.compare(version) >= 0;
    }

    public boolean isLessOrEqual(Version version) {
        return this.compare(version) <= 0;
    }

    private int compare(Version version) {
        if (this.major != version.major) {
            return this.major - version.major;
        }
        if (this.minor != version.minor) {
            return this.minor - version.minor;
        }
        return this.patch - version.patch;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (this.qualifier != null ? this.qualifier : "");
    }

    @Override
    public int compareTo(Version o) {
        int thisVersion = this.pack();
        int thatVersion = o.pack();
        return thisVersion - thatVersion;
    }

    public String toShortFormat() {
        return this.major + "." + this.minor;
    }

    public static Version of(String version) {
        return new Version(version);
    }

    public com.hazelcast.version.Version toHazelcastVersion() {
        return com.hazelcast.version.Version.of((int)this.major, (int)this.minor);
    }

    private int pack() {
        return this.major << 8 & 0xFF00 | this.minor & 0xFF;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getPatch() != other.getPatch()) {
            return false;
        }
        String this$qualifier = this.getQualifier();
        String other$qualifier = other.getQualifier();
        return !(this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        String $qualifier = this.getQualifier();
        result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
        return result;
    }
}

