/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.jet.tagexpressions;

import com.hazelcast.webmonitor.metrics.jet.tagexpressions.TagExpression;
import java.util.Map;
import java.util.Objects;

public class NotEqualsExpression
implements TagExpression {
    private final String tag;
    private final String value;

    public NotEqualsExpression(String tag, String value) {
        this.tag = tag;
        this.value = value;
    }

    public boolean matches(Map<String, String> parsedTags) {
        return !Objects.equals(this.value, parsedTags.get(this.tag));
    }

    public String toString() {
        return this.tag + "!=" + this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotEqualsExpression that = (NotEqualsExpression)o;
        return Objects.equals(this.tag, that.tag) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.value);
    }
}

