/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.utils.TimeUtil;

/*
 * Exception performing whole class analysis ignored.
 */
final class RocksDBTimeUtil {
    private static final int SEC_IN_MIN = 60;
    private static final long MS_IN_SEC = 1000L;

    private RocksDBTimeUtil() {
    }

    static long minuteStart(long time) {
        return time - time % TimeUtil.ONE_MINUTE_IN_MS;
    }

    static long prevMinuteStart(long time) {
        return RocksDBTimeUtil.minuteStart((long)time) - TimeUtil.ONE_MINUTE_IN_MS;
    }

    static boolean isMinuteStart(long time) {
        return time % TimeUtil.ONE_MINUTE_IN_MS == 0L;
    }

    static int minuteOffset(long time) {
        return (int)((time - RocksDBTimeUtil.minuteStart((long)time)) / 1000L);
    }

    static long[] minuteStarts(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("Range start must not be later than range end.");
        }
        long left = RocksDBTimeUtil.minuteStart((long)start);
        long right = RocksDBTimeUtil.minuteStart((long)end) + 1L;
        int size = (int)((right - left) / TimeUtil.ONE_MINUTE_IN_MS) + 1;
        long[] res = new long[size];
        for (int i = 0; i < size; ++i) {
            res[i] = left + (long)i * TimeUtil.ONE_MINUTE_IN_MS;
        }
        return res;
    }

    static long[] minuteTimePoints(long minStart) {
        if (!RocksDBTimeUtil.isMinuteStart((long)minStart)) {
            throw new IllegalArgumentException("Minute start must be provided.");
        }
        long[] res = new long[60];
        for (int i = 0; i < res.length; ++i) {
            res[i] = minStart + (long)i * 1000L;
        }
        return res;
    }

    static long minuteTimePoint(long minStart, int offset) {
        if (!RocksDBTimeUtil.isMinuteStart((long)minStart)) {
            throw new IllegalArgumentException("Minute start must be provided.");
        }
        if (offset < 0 || offset >= 60) {
            throw new IllegalArgumentException("Offset must be within 0-59 range.");
        }
        return minStart + (long)offset * 1000L;
    }
}

