/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBValueUtil;
import com.hazelcast.webmonitor.metrics.utils.ValueUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLongArray;

final class MinuteSeriesSerde {
    static final byte MAX_VALUE_BYTE = 31;
    static final short MAX_VALUE_SHORT = 8191;
    static final int MAX_VALUE_INT = 0x1FFFFFFF;
    private static final int OP_PLAIN_LONG = 0;
    private static final int OP_SAME = 32;
    private static final int OP_BYTE_POSITIVE = 64;
    private static final int OP_BYTE_NEGATIVE = 96;
    private static final int OP_SHORT_POSITIVE = 128;
    private static final int OP_SHORT_NEGATIVE = 160;
    private static final int OP_INT_POSITIVE = 192;
    private static final int OP_INT_NEGATIVE = 224;
    private static final int OPERATION_MASK = 224;
    private static final long DENSE_BITSET = 0xFFFFFFFFFFFFFFFL;

    private MinuteSeriesSerde() {
        throw new IllegalStateException("Should never be instantiated");
    }

    static int serialize(AtomicLongArray minuteValues, ByteBuffer dest) {
        if (minuteValues.length() != 60) {
            throw new IllegalArgumentException("Only minute values are supported");
        }
        dest.clear();
        long bitSet = 0L;
        for (int i = 0; i < minuteValues.length(); ++i) {
            long value = minuteValues.get(i);
            if (ValueUtil.isMissingValue((long)value)) continue;
            bitSet |= 1L << i;
        }
        byte availableValues = (byte)Long.bitCount(bitSet);
        dest.put(availableValues);
        if (availableValues == 0) {
            return dest.flip().limit();
        }
        if (availableValues < 60) {
            dest.putLong(Long.reverseBytes(bitSet));
        }
        long last = 0L;
        int startPosition = dest.position();
        boolean wasSame = false;
        int lastLongIndex = -1;
        while (bitSet != 0L) {
            int index = Long.numberOfTrailingZeros(bitSet);
            long val = minuteValues.get(index);
            if (val == last) {
                int times;
                int previousIndex = dest.position() - 1;
                int n = times = wasSame ? dest.get(previousIndex) & 0x1F : 0;
                if (times > 0 && times < 31) {
                    dest.put(previousIndex, (byte)(0x20 | times + 1));
                } else {
                    dest.put((byte)33);
                }
            } else {
                boolean neg;
                long absDelta;
                try {
                    long delta = Math.subtractExact(val, last);
                    absDelta = delta < 0L ? Math.negateExact(delta) : delta;
                    neg = delta < 0L;
                }
                catch (ArithmeticException e) {
                    absDelta = Long.MAX_VALUE;
                    neg = false;
                }
                if (absDelta <= 31L) {
                    dest.put((byte)(absDelta | (long)(neg ? 96 : 64)));
                } else if (absDelta <= 8191L) {
                    dest.putShort((short)(absDelta | (long)((neg ? 160 : 128) << 8)));
                } else if (absDelta <= 0x1FFFFFFFL) {
                    dest.putInt((int)(absDelta | (long)((neg ? 224 : 192) << 24)));
                } else {
                    byte count;
                    byte by = count = lastLongIndex < 0 ? (byte)0 : dest.get(lastLongIndex);
                    if (count == 0 || count >= 31 || count * 8 + lastLongIndex - startPosition + 1 < dest.position() - startPosition) {
                        lastLongIndex = dest.position();
                        dest.put((byte)1);
                    } else {
                        count = (byte)(count + 1);
                        dest.put(lastLongIndex, count);
                    }
                    dest.putLong(val);
                }
            }
            wasSame = last == val;
            last = val;
            bitSet &= bitSet - 1L;
        }
        return dest.flip().limit();
    }

    static long[] deserialize(ByteBuffer src) {
        byte seriesSize = src.get();
        if (seriesSize < 0 || seriesSize > 60) {
            throw new IllegalArgumentException("Only minute values are supported");
        }
        long[] values = RocksDBValueUtil.emptyMinuteBucket();
        if (seriesSize == 0) {
            return values;
        }
        long cur = 0L;
        for (long bitSet = seriesSize == 60 ? 0xFFFFFFFFFFFFFFFL : Long.reverseBytes(src.getLong()); bitSet != 0L; bitSet &= bitSet - 1L) {
            byte firstByte = src.get();
            int operation = firstByte & 0xE0;
            switch (operation) {
                case 64: {
                    cur += (long)(firstByte & 0x1F);
                    break;
                }
                case 96: {
                    cur -= (long)(firstByte & 0x1F);
                    break;
                }
                case 128: {
                    src.position(src.position() - 1);
                    cur += (long)(src.getShort() & 0x1FFF);
                    break;
                }
                case 160: {
                    src.position(src.position() - 1);
                    cur -= (long)(src.getShort() & 0x1FFF);
                    break;
                }
                case 192: {
                    src.position(src.position() - 1);
                    cur += (long)(src.getInt() & 0x1FFFFFFF);
                    break;
                }
                case 224: {
                    src.position(src.position() - 1);
                    cur -= (long)(src.getInt() & 0x1FFFFFFF);
                    break;
                }
                case 0: {
                    int i;
                    int k;
                    int times = (firstByte & 0x1F) - 1;
                    for (k = 0; k < times; ++k) {
                        i = Long.numberOfTrailingZeros(bitSet);
                        values[i] = src.getLong();
                        bitSet &= bitSet - 1L;
                    }
                    cur = src.getLong();
                    break;
                }
                case 32: {
                    int i;
                    int k;
                    int times = (firstByte & 0x1F) - 1;
                    for (k = 0; k < times; ++k) {
                        i = Long.numberOfTrailingZeros(bitSet);
                        values[i] = cur;
                        bitSet &= bitSet - 1L;
                    }
                    break;
                }
            }
            int i = Long.numberOfTrailingZeros(bitSet);
            values[i] = cur;
        }
        return values;
    }
}

