/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointType;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.utils.MetricsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public final class MetricDataPoint
implements DataPointAware,
Serializable {
    @NonNull
    private final String metric;
    @NonNull
    private final Map<String, String> tags;
    private final long time;
    private final long value;
    @NonNull
    private final DataPointType type;
    private final String unit;

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.metric;
    }

    public double getDoubleValue() {
        if (this.type == DataPointType.DOUBLE) {
            return MetricsUtil.toOriginalMetricValue((long)this.value);
        }
        throw new IllegalStateException("Double value is not supported for " + String.valueOf(this.type) + " type");
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMetric() {
        return this.metric;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTime() {
        return this.time;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getValue() {
        return this.value;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataPointType getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getUnit() {
        return this.unit;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricDataPoint)) {
            return false;
        }
        MetricDataPoint other = (MetricDataPoint)o;
        if (this.getTime() != other.getTime()) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$metric = this.getMetric();
        String other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        Map this$tags = this.getTags();
        Map other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        DataPointType this$type = this.getType();
        DataPointType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        long $value = this.getValue();
        result = result * 59 + (int)($value >>> 32 ^ $value);
        String $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        Map $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        DataPointType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MetricDataPoint(metric=" + this.getMetric() + ", tags=" + String.valueOf(this.getTags()) + ", time=" + this.getTime() + ", value=" + this.getValue() + ", type=" + String.valueOf(this.getType()) + ", unit=" + this.getUnit() + ")";
    }

    @ConstructorProperties(value={"metric", "tags", "time", "value", "type", "unit"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    MetricDataPoint(@NonNull String metric, @NonNull Map<String, String> tags, long time, long value, @NonNull DataPointType type, String unit) {
        if (metric == null) {
            throw new NullPointerException("metric is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.metric = metric;
        this.tags = tags;
        this.time = time;
        this.value = value;
        this.type = type;
        this.unit = unit;
    }
}

