/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics;

import com.fasterxml.jackson.annotation.JsonValue;
import com.hazelcast.webmonitor.metrics.DataPointType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Metric {
    CACHE_AVERAGE_GET_TIME("cache", "averageGetTime", DataPointType.DOUBLE),
    CACHE_AVERAGE_PUT_TIME("cache", "averagePutTime", DataPointType.DOUBLE),
    CACHE_AVERAGE_REMOVAL_TIME("cache", "averageRemovalTime", DataPointType.DOUBLE),
    CACHE_EVICTIONS("cache", "cacheEvictions"),
    CACHE_GETS("cache", "cacheGets"),
    CACHE_HITS("cache", "cacheHits"),
    CACHE_HIT_PERCENTAGE("cache", "cacheHitPercentage", DataPointType.DOUBLE),
    CACHE_MISSES("cache", "cacheMisses"),
    CACHE_MISS_PERCENTAGE("cache", "cacheMissPercentage", DataPointType.DOUBLE),
    CACHE_PUTS("cache", "cachePuts"),
    CACHE_REMOVALS("cache", "cacheRemovals"),
    CACHE_CREATION_TIME("cache", "creationTime"),
    CACHE_LAST_ACCESS_TIME("cache", "lastAccessTime"),
    CACHE_LAST_UPDATE_TIME("cache", "lastUpdateTime"),
    CACHE_OWNED_ENTRY_COUNT("cache", "ownedEntryCount"),
    CLASSLOADING_LOADED_CLASSES_COUNT("classloading.loadedClassesCount"),
    CLASSLOADING_TOTAL_LOADED_CLASSES_COUNT("classloading.totalLoadedClassesCount"),
    CLASSLOADING_UNLOADED_CLASSES_COUNT("classloading.unloadedClassesCount"),
    CLUSTER_CLOCK_CLUSTER_UP_TIME("cluster.clock", "clusterUpTime"),
    CLUSTER_HEARTBEAT_LAST_HEARTBEAT("cluster.heartbeat", "lastHeartbeat"),
    EVENT_QUEUE_SIZE("event", "eventQueueSize"),
    EVENT_QUEUE_CAPACITY("event", "queueCapacity"),
    EVENT_THREAD_COUNT("event", "threadCount"),
    EXECUTOR_CREATION_TIME("executor", "creationTime"),
    EXECUTOR_PENDING("executor", "pending"),
    EXECUTOR_STARTED("executor", "started"),
    EXECUTOR_CANCELLED("executor", "cancelled"),
    EXECUTOR_COMPLETED("executor", "completed"),
    EXECUTOR_TOTAL_EXECUTION_TIME("executor", "totalExecutionTime"),
    EXECUTOR_TOTAL_START_LATENCY("executor", "totalStartLatency"),
    EXECUTOR_INTERNAL_QUEUE_SIZE("executor.internal", "queueSize"),
    EXECUTOR_INTERNAL_MAXIMUM_POOL_SIZE("executor.internal", "maximumPoolSize"),
    EXECUTOR_INTERNAL_POOL_SIZE("executor.internal", "poolSize"),
    EXECUTOR_INTERNAL_REMAINING_QUEUE_CAPACITY("executor.internal", "remainingQueueCapacity"),
    EXECUTOR_INTERNAL_COMPLETED_TASKS("executor.internal", "completedTasks"),
    FLAKE_ID_GENERATOR_CREATION_TIME("flakeIdGenerator", "creationTime"),
    FLAKE_ID_GENERATOR_BATCH_COUNT("flakeIdGenerator", "batchCount"),
    FLAKE_ID_GENERATOR_ID_COUNT("flakeIdGenerator", "idCount"),
    GC_MAJOR_COUNT("gc", "majorCount"),
    GC_MAJOR_TIME("gc", "majorTime"),
    GC_MINOR_COUNT("gc", "minorCount"),
    GC_MINOR_TIME("gc", "minorTime"),
    INVOCATIONS_STARTED_INVOCATIONS("invocations", "startedInvocations"),
    JOB_DISTRIBUTED_ITEMS_IN("job", "distributedItemsIn"),
    JOB_DISTRIBUTED_ITEMS_OUT("job", "distributedItemsOut"),
    LIST_CREATION_TIME("list", "creationTime", DataPointType.LONG, false),
    LIST_LAST_ACCESS_TIME("list", "lastAccessTime", DataPointType.LONG, false),
    LIST_LAST_UPDATE_TIME("list", "lastUpdateTime", DataPointType.LONG, false),
    MAP_BACKUP_ENTRY_COUNT("map", "backupEntryCount"),
    MAP_BACKUP_ENTRY_MEMORY_COST("map", "backupEntryMemoryCost"),
    MAP_CREATION_TIME("map", "creationTime"),
    MAP_DIRTY_ENTRY_COUNT("map", "dirtyEntryCount"),
    MAP_GET_COUNT("map", "getCount"),
    MAP_HEAP_COST("map", "heapCost"),
    MAP_HITS("map", "hits"),
    MAP_LAST_ACCESS_TIME("map", "lastAccessTime"),
    MAP_LAST_UPDATE_TIME("map", "lastUpdateTime"),
    MAP_LOCKED_ENTRY_COUNT("map", "lockedEntryCount"),
    MAP_NUMBER_OF_EVENTS("map", "numberOfEvents"),
    MAP_NUMBER_OF_OTHER_OPERATIONS("map", "numberOfOtherOperations"),
    MAP_OWNED_ENTRY_COUNT("map", "ownedEntryCount"),
    MAP_OWNED_ENTRY_MEMORY_COST("map", "ownedEntryMemoryCost"),
    MAP_PUT_COUNT("map", "putCount"),
    MAP_REMOVE_COUNT("map", "removeCount"),
    MAP_SET_COUNT("map", "setCount"),
    MAP_TOTAL_GET_LATENCY("map", "totalGetLatency"),
    MAP_TOTAL_MAX_GET_LATENCY("map", "totalMaxGetLatency"),
    MAP_TOTAL_PUT_LATENCY("map", "totalPutLatency"),
    MAP_TOTAL_MAX_PUT_LATENCY("map", "totalMaxPutLatency"),
    MAP_TOTAL_REMOVE_LATENCY("map", "totalRemoveLatency"),
    MAP_TOTAL_MAX_REMOVE_LATENCY("map", "totalMaxRemoveLatency"),
    MAP_TOTAL_SET_LATENCY("map", "totalSetLatency"),
    MAP_TOTAL_MAX_SET_LATENCY("map", "totalMaxSetLatency"),
    MAP_INDEX_CREATION_TIME("map.index", "creationTime"),
    MAP_INDEX_QUERY_COUNT("map.index", "queryCount"),
    MAP_INDEX_HIT_COUNT("map.index", "hitCount"),
    MAP_INDEX_AVERAGE_HIT_LATENCY("map.index", "averageHitLatency"),
    MAP_INDEX_AVERAGE_HIT_SELECTIVITY("map.index", "averageHitSelectivity", DataPointType.DOUBLE),
    MAP_INDEX_INSERT_COUNT("map.index", "insertCount"),
    MAP_INDEX_TOTAL_INSERT_LATENCY("map.index", "totalInsertLatency"),
    MAP_INDEX_UPDATE_COUNT("map.index", "updateCount"),
    MAP_INDEX_TOTAL_UPDATE_LATENCY("map.index", "totalUpdateLatency"),
    MAP_INDEX_REMOVE_COUNT("map.index", "removeCount"),
    MAP_INDEX_TOTAL_REMOVE_LATENCY("map.index", "totalRemoveLatency"),
    MAP_INDEX_MEMORY_COST("map.index", "memoryCost"),
    MAP_NEARCACHE_HITS("map.nearcache", "hits"),
    MAP_NEARCACHE_MISSES("map.nearcache", "misses"),
    MAP_NEARCACHE_OWNED_ENTRY_COUNT("map.nearcache", "ownedEntryCount"),
    MAP_NEARCACHE_OWNED_ENTRY_MEMORY_COST("map.nearcache", "ownedEntryMemoryCost"),
    MEMORY_COMMITTED_HEAP("memory", "committedHeap"),
    MEMORY_COMMITTED_NATIVE("memory", "committedNative"),
    MEMORY_FREE_HEAP("memory", "freeHeap"),
    MEMORY_FREE_NATIVE("memory", "freeNative"),
    MEMORY_MAX_HEAP("memory", "maxHeap"),
    MEMORY_MAX_NATIVE("memory", "maxNative"),
    MEMORY_USED_METADATA("memory", "usedMetadata"),
    MEMORY_MAX_METADATA("memory", "maxMetadata"),
    MEMORY_USED_HEAP("memory", "usedHeap"),
    MEMORY_USED_NATIVE("memory", "usedNative"),
    MULTI_MAP_BACKUP_ENTRY_COUNT("multiMap", "backupEntryCount"),
    MULTI_MAP_BACKUP_ENTRY_MEMORY_COST("multiMap", "backupEntryMemoryCost"),
    MULTI_MAP_CREATION_TIME("multiMap", "creationTime"),
    MULTI_MAP_DIRTY_ENTRY_COUNT("multiMap", "dirtyEntryCount"),
    MULTI_MAP_GET_COUNT("multiMap", "getCount"),
    MULTI_MAP_HEAP_COST("multiMap", "heapCost"),
    MULTI_MAP_HITS("multiMap", "hits"),
    MULTI_MAP_LAST_ACCESS_TIME("multiMap", "lastAccessTime"),
    MULTI_MAP_LAST_UPDATE_TIME("multiMap", "lastUpdateTime"),
    MULTI_MAP_LOCKED_ENTRY_COUNT("multiMap", "lockedEntryCount"),
    MULTI_MAP_NUMBER_OF_EVENTS("multiMap", "numberOfEvents"),
    MULTI_MAP_NUMBER_OF_OTHER_OPERATIONS("multiMap", "numberOfOtherOperations"),
    MULTI_MAP_OWNED_ENTRY_COUNT("multiMap", "ownedEntryCount"),
    MULTI_MAP_OWNED_ENTRY_MEMORY_COST("multiMap", "ownedEntryMemoryCost"),
    MULTI_MAP_PUT_COUNT("multiMap", "putCount"),
    MULTI_MAP_REMOVE_COUNT("multiMap", "removeCount"),
    MULTI_MAP_TOTAL_GET_LATENCY("multiMap", "totalGetLatency"),
    MULTI_MAP_TOTAL_MAX_GET_LATENCY("multiMap", "totalMaxGetLatency"),
    MULTI_MAP_TOTAL_PUT_LATENCY("multiMap", "totalPutLatency"),
    MULTI_MAP_TOTAL_MAX_PUT_LATENCY("multiMap", "totalMaxPutLatency"),
    MULTI_MAP_TOTAL_REMOVE_LATENCY("multiMap", "totalRemoveLatency"),
    MULTI_MAP_TOTAL_MAX_REMOVE_LATENCY("multiMap", "totalMaxRemoveLatency"),
    NEARCACHE_HITS("nearcache", "hits"),
    NEARCACHE_MISSES("nearcache", "misses"),
    NEARCACHE_CREATION_TIME("nearcache", "creationTime"),
    NEARCACHE_EVICTIONS("nearcache", "evictions"),
    NEARCACHE_EXPIRATIONS("nearcache", "expirations"),
    NEARCACHE_OWNED_ENTRY_COUNT("nearcache", "ownedEntryCount"),
    NEARCACHE_OWNED_ENTRY_MEMORY_COST("nearcache", "ownedEntryMemoryCost"),
    NEARCACHE_LAST_PERSISTENCE_DURATION("nearcache", "lastPersistenceDuration"),
    NEARCACHE_LAST_PERSISTENCE_KEY_COUNT("nearcache", "lastPersistenceKeyCount"),
    NEARCACHE_LAST_PERSISTENCE_TIME("nearcache", "lastPersistenceTime"),
    NEARCACHE_LAST_PERSISTENCE_WRITTEN_BYTES("nearcache", "lastPersistenceWrittenBytes"),
    NEARCACHE_INVALIDATION_REQUESTS("nearcache", "invalidationRequests"),
    NEARCACHE_INVALIDATIONS("nearcache", "invalidations"),
    OPERATION_COMPLETED_COUNT("operation", "completedCount"),
    OPERATION_INVOCATIONS_PENDING("operation", "pending"),
    OPERATION_PARTITION_THREAD_COUNT("operation", "partitionThreadCount"),
    OPERATION_QUEUE_SIZE("operation", "queueSize"),
    OPERATION_RESPONSE_QUEUE_SIZE("operation", "responseQueueSize"),
    OPERATION_RUNNING_COUNT("operation", "runningCount"),
    PARTITIONS_ACTIVE_PARTITION_COUNT("partitions", "activePartitionCount"),
    PARTITIONS_LOCAL_PARTITION_COUNT("partitions", "localPartitionCount"),
    PARTITIONS_PARTITION_COUNT("partitions", "partitionCount"),
    PARTITIONS_MIGRATION_QUEUE_SIZE("partitions", "migrationQueueSize"),
    PN_COUNTER_CREATION_TIME("pnCounter", "creationTime"),
    PN_COUNTER_VALUE("pnCounter", "value"),
    PN_COUNTER_TOTAL_DECREMENT_OPERATION_COUNT("pnCounter", "totalDecrementOperationCount"),
    PN_COUNTER_TOTAL_INCREMENT_OPERATION_COUNT("pnCounter", "totalIncrementOperationCount"),
    PROXY_CREATED_COUNT("proxy", "createdCount"),
    PROXY_DESTROYED_COUNT("proxy", "destroyedCount"),
    PROXY_COUNT("proxy", "proxyCount"),
    QUEUE_AVERAGE_AGE("queue", "averageAge"),
    QUEUE_BACKUP_ITEM_COUNT("queue", "backupItemCount"),
    QUEUE_CREATION_TIME("queue", "creationTime"),
    QUEUE_MAX_AGE("queue", "maxAge"),
    QUEUE_MIN_AGE("queue", "minAge"),
    QUEUE_NUMBER_OF_EMPTY_POLLS("queue", "numberOfEmptyPolls"),
    QUEUE_NUMBER_OF_EVENTS("queue", "numberOfEvents"),
    QUEUE_NUMBER_OF_OFFERS("queue", "numberOfOffers"),
    QUEUE_NUMBER_OF_OTHER_OPERATIONS("queue", "numberOfOtherOperations"),
    QUEUE_NUMBER_OF_POLLS("queue", "numberOfPolls"),
    QUEUE_NUMBER_OF_REJECTED_OFFERS("queue", "numberOfRejectedOffers"),
    QUEUE_OWNED_ITEM_COUNT("queue", "ownedItemCount"),
    RELIABLE_TOPIC_CREATION_TIME("reliableTopic", "creationTime"),
    RELIABLE_TOPIC_TOTAL_PUBLISHES("reliableTopic", "totalPublishes"),
    RELIABLE_TOPIC_TOTAL_RECEIVED_MESSAGES("reliableTopic", "totalReceivedMessages"),
    REPLICATEDMAP_BACKUP_ENTRY_COUNT("replicatedMap", "backupEntryCount"),
    REPLICATEDMAP_BACKUP_ENTRY_MEMORY_COST("replicatedMap", "backupEntryMemoryCost"),
    REPLICATEDMAP_CREATION_TIME("replicatedMap", "creationTime"),
    REPLICATEDMAP_DIRTY_ENTRY_COUNT("replicatedMap", "dirtyEntryCount"),
    REPLICATEDMAP_GET_COUNT("replicatedMap", "getCount"),
    REPLICATEDMAP_HITS("replicatedMap", "hits"),
    REPLICATEDMAP_LAST_ACCESS_TIME("replicatedMap", "lastAccessTime"),
    REPLICATEDMAP_LAST_UPDATE_TIME("replicatedMap", "lastUpdateTime"),
    REPLICATEDMAP_LOCKED_ENTRY_COUNT("replicatedMap", "lockedEntryCount"),
    REPLICATEDMAP_NUMBER_OF_EVENTS("replicatedMap", "numberOfEvents"),
    REPLICATEDMAP_NUMBER_OF_OTHER_OPERATIONS("replicatedMap", "numberOfOtherOperations"),
    REPLICATEDMAP_OWNED_ENTRY_COUNT("replicatedMap", "ownedEntryCount"),
    REPLICATEDMAP_OWNED_ENTRY_MEMORY_COST("replicatedMap", "ownedEntryMemoryCost"),
    REPLICATEDMAP_PUT_COUNT("replicatedMap", "putCount"),
    REPLICATEDMAP_REMOVE_COUNT("replicatedMap", "removeCount"),
    REPLICATEDMAP_TOTAL_GET_LATENCY("replicatedMap", "totalGetLatencies"),
    REPLICATEDMAP_TOTAL_MAX_GET_LATENCY("replicatedMap", "maxGetLatency"),
    REPLICATEDMAP_TOTAL_PUT_LATENCY("replicatedMap", "totalPutLatencies"),
    REPLICATEDMAP_TOTAL_MAX_PUT_LATENCY("replicatedMap", "maxPutLatency"),
    REPLICATEDMAP_TOTAL_REMOVE_LATENCY("replicatedMap", "totalRemoveLatencies"),
    REPLICATEDMAP_TOTAL_MAX_REMOVE_LATENCY("replicatedMap", "maxRemoveLatency"),
    OS_COMMITTED_VIRTUAL_MEMORY_SIZE("os.committedVirtualMemorySize"),
    OS_TOTAL_PHYSICAL_MEMORY_SIZE("os.totalPhysicalMemorySize"),
    OS_FREE_PHYSICAL_MEMORY_SIZE("os.freePhysicalMemorySize"),
    OS_TOTAL_SWAP_SPACE_SIZE("os.totalSwapSpaceSize"),
    OS_FREE_SWAP_SPACE_SIZE("os.freeSwapSpaceSize"),
    OS_MAX_FILE_DESCRIPTOR_COUNT("os.maxFileDescriptorCount"),
    OS_OPEN_FILE_DESCRIPTOR_COUNT("os.openFileDescriptorCount"),
    OS_PROCESS_CPU_TIME("os.processCpuTime"),
    OS_PROCESS_CPU_LOAD("os.processCpuLoad", DataPointType.DOUBLE),
    OS_SYSTEM_CPU_LOAD("os.systemCpuLoad", DataPointType.DOUBLE),
    OS_SYSTEM_LOAD_AVERAGE("os.systemLoadAverage", DataPointType.DOUBLE),
    RUNTIME_AVAILABLE_PROCESSORS("runtime.availableProcessors"),
    RUNTIME_FREE_MEMORY("runtime.freeMemory"),
    RUNTIME_MAX_MEMORY("runtime.maxMemory"),
    RUNTIME_TOTAL_MEMORY("runtime.totalMemory"),
    RUNTIME_USED_MEMORY("runtime.usedMemory"),
    RUNTIME_UPTIME("runtime.uptime"),
    SET_CREATION_TIME("set", "creationTime", DataPointType.LONG, false),
    SET_LAST_ACCESS_TIME("set", "lastAccessTime", DataPointType.LONG, false),
    SET_LAST_UPDATE_TIME("set", "lastUpdateTime", DataPointType.LONG, false),
    TCP_CONNECTION_ACTIVE_COUNT("tcp.connection", "activeCount"),
    TCP_CONNECTION_CLIENT_COUNT("tcp.connection", "clientCount"),
    TCP_CONNECTION_COUNT("tcp.connection", "count"),
    THREAD_DAEMON_THREAD_COUNT("thread.daemonThreadCount"),
    THREAD_PEAK_THREAD_COUNT("thread.peakThreadCount"),
    THREAD_THREAD_COUNT("thread.threadCount"),
    TOPIC_CREATION_TIME("topic", "creationTime"),
    TOPIC_TOTAL_PUBLISHES("topic", "totalPublishes"),
    TOPIC_TOTAL_RECEIVED_MESSAGES("topic", "totalReceivedMessages"),
    TIERED_STORE_DEVICE_USED_SPACE("tstore.device.ts.used"),
    TIERED_STORE_DEVICE_CAPACITY("tstore.device.ts.capacity"),
    TIERED_STORE_PHYSICAL_DEVICE_CAPACITY("tstore.device.sys.capacity", DataPointType.LONG, false),
    WAN_REPL_OUTBOUND_QUEUE_SIZE("wan", "outboundQueueSize"),
    WAN_REPL_QUEUE_FILL_PERCENT("wan", "queueFillPercent"),
    WAN_REPL_TOTAL_PUBLISH_LATENCY("wan", "totalPublishLatency"),
    WAN_REPL_TOTAL_PUBLISHED_EVENT_COUNT("wan", "totalPublishedEventCount"),
    VC_CREATION_TIME("vectorCollection", "creationTime"),
    VC_LAST_ACCESS_TIME("vectorCollection", "lastAccessTime"),
    VC_LAST_UPDATE_TIME("vectorCollection", "lastUpdateTime"),
    VC_OWNED_ENTRY_COUNT("vectorCollection", "ownedEntryCount"),
    VC_HEAP_COST("vectorCollection", "heapCost"),
    VC_OWNED_ENTRY_HEAP_MEMORY_COST("vectorCollection", "ownedEntryHeapMemoryCost"),
    VC_BACKUP_COUNT("vectorCollection", "backupCount"),
    VC_BACKUP_ENTRY_COUNT("vectorCollection", "backupEntryCount"),
    VC_BACKUP_ENTRY_HEAP_MEMORY_COST("vectorCollection", "backupEntryHeapMemoryCost"),
    VC_GET_COUNT("vectorCollection", "getCount"),
    VC_TOTAL_GET_LATENCY("vectorCollection", "totalGetLatency"),
    VC_TOTAL_MAX_GET_LATENCY("vectorCollection", "totalMaxGetLatency"),
    VC_PUT_ALL_ENTRY_COUNT("vectorCollection", "putAllEntryCount"),
    VC_PUT_ALL_COUNT("vectorCollection", "putAllCount"),
    VC_TOTAL_PUT_ALL_LATENCY("vectorCollection", "totalPutAllLatency"),
    VC_TOTAL_MAX_PUT_ALL_LATENCY("vectorCollection", "totalMaxPutAllLatency"),
    VC_PUT_COUNT("vectorCollection", "putCount"),
    VC_TOTAL_PUT_LATENCY("vectorCollection", "totalPutLatency"),
    VC_TOTAL_MAX_PUT_LATENCY("vectorCollection", "totalMaxPutLatency"),
    VC_SET_COUNT("vectorCollection", "setCount"),
    VC_TOTAL_SET_LATENCY("vectorCollection", "totalSetLatency"),
    VC_TOTAL_MAX_SET_LATENCY("vectorCollection", "totalMaxSetLatency"),
    VC_REMOVE_COUNT("vectorCollection", "removeCount"),
    VC_TOTAL_REMOVE_LATENCY("vectorCollection", "totalRemoveLatency"),
    VC_TOTAL_MAX_REMOVE_LATENCY("vectorCollection", "totalMaxRemoveLatency"),
    VC_DELETE_COUNT("vectorCollection", "deleteCount"),
    VC_TOTAL_DELETE_LATENCY("vectorCollection", "totalDeleteLatency"),
    VC_TOTAL_MAX_DELETE_LATENCY("vectorCollection", "totalMaxDeleteLatency"),
    VC_CLEAR_COUNT("vectorCollection", "clearCount"),
    VC_TOTAL_CLEAR_LATENCY("vectorCollection", "totalClearLatency"),
    VC_MAX_CLEAR_LATENCY("vectorCollection", "maxClearLatency"),
    VC_SEARCH_COUNT("vectorCollection", "searchCount"),
    VC_SEARCH_RESULTS_COUNT("vectorCollection", "searchResultsCount"),
    VC_TOTAL_SEARCH_LATENCY("vectorCollection", "totalSearchLatency"),
    VC_MAX_SEARCH_LATENCY("vectorCollection", "maxSearchLatency"),
    VC_SIZE_COUNT("vectorCollection", "sizeCount"),
    VC_TOTAL_SIZE_LATENCY("vectorCollection", "totalSizeLatency"),
    VC_MAX_SIZE_LATENCY("vectorCollection", "maxSizeLatency"),
    VC_OPTIMIZE_COUNT("vectorCollection", "optimizeCount"),
    VC_TOTAL_OPTIMIZE_LATENCY("vectorCollection", "totalOptimizeLatency"),
    VC_MAX_OPTIMIZE_LATENCY("vectorCollection", "maxOptimizeLatency");

    @JsonValue
    final String name;
    final DataPointType type;
    final boolean persistent;
    static final Map<String, Metric> NAME_TO_VALUE_MAP;

    private Metric(String prefix, String name) {
        this(string, n, prefix, name, DataPointType.LONG);
    }

    private Metric(String prefix, String name, DataPointType type) {
        this(string, n, prefix + "." + name, type);
    }

    private Metric(String prefix, String name, DataPointType type, boolean persistent) {
        this(string, n, prefix + "." + name, type, persistent);
    }

    private Metric(String name) {
        this(string, n, name, DataPointType.LONG);
    }

    private Metric(String name, DataPointType dataPointType) {
        this(string, n, name, dataPointType, true);
    }

    private Metric(String name, DataPointType type, boolean persistent) {
        this.name = name;
        this.type = type;
        this.persistent = persistent;
    }

    public String toString() {
        return this.name;
    }

    @Nonnull
    public static Metric forName(@Nonnull String name) {
        Metric metric = (Metric)NAME_TO_VALUE_MAP.get(name);
        if (metric == null) {
            throw new NoSuchElementException("There is no Metric with name = " + name);
        }
        return metric;
    }

    @Nullable
    public static Metric forNameQuiet(@Nonnull String name) {
        return (Metric)NAME_TO_VALUE_MAP.get(name);
    }

    public static boolean isPersistent(String metricName) {
        Metric metric = Metric.forNameQuiet((String)metricName);
        return metric != null && metric.persistent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DataPointType getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isPersistent() {
        return this.persistent;
    }

    static {
        NAME_TO_VALUE_MAP = Arrays.stream(Metric.values()).collect(Collectors.toMap(Metric::getName, Function.identity()));
    }
}

