/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events;

import com.hazelcast.webmonitor.events.ConfigUpdateEventStore;
import com.hazelcast.webmonitor.events.DiagnosticsConfigUpdatedEventStore;
import com.hazelcast.webmonitor.events.EventVisitor;
import com.hazelcast.webmonitor.events.WanEventStore;
import com.hazelcast.webmonitor.events.model.AbstractWanEvent;
import com.hazelcast.webmonitor.events.model.ConfigUpdateEvent;
import com.hazelcast.webmonitor.events.model.DiagnosticsConfigUpdatedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventGroupingVisitor
implements EventVisitor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventGroupingVisitor.class);
    private final WanEventStore wanEventStore;
    private final ConfigUpdateEventStore configUpdateEventStore;
    private final DiagnosticsConfigUpdatedEventStore diagnosticsConfigUpdatedEventStore;
    private List<AbstractWanEvent> wanEvents = new ArrayList();
    private List<ConfigUpdateEvent> configUpdateEvents = new ArrayList();
    private List<DiagnosticsConfigUpdatedEvent> diagnosticsConfigUpdatedEvents = new ArrayList();

    public void visitAbstractWanEvent(AbstractWanEvent event) {
        log.info("received wan event {}", (Object)event);
        this.wanEvents.add(event);
    }

    public void visitConfigUpdateEvent(ConfigUpdateEvent event) {
        log.info("received dynamic config event {}", (Object)event);
        this.configUpdateEvents.add(event);
    }

    public void visitDiagnosticsConfigUpdatedEvent(DiagnosticsConfigUpdatedEvent event) {
        log.info("received diagnostics config updated event {}", (Object)event);
        this.diagnosticsConfigUpdatedEvents.add(event);
    }

    public void batchFinished(String cluster) {
        if (!this.wanEvents.isEmpty()) {
            this.wanEventStore.store(cluster, this.wanEvents);
            this.wanEvents = new ArrayList();
        }
        if (!this.configUpdateEvents.isEmpty()) {
            this.configUpdateEventStore.store(this.configUpdateEvents);
            this.configUpdateEvents = new ArrayList();
        }
        if (!this.diagnosticsConfigUpdatedEvents.isEmpty()) {
            this.diagnosticsConfigUpdatedEventStore.store(this.diagnosticsConfigUpdatedEvents);
            this.diagnosticsConfigUpdatedEvents = new ArrayList();
        }
    }

    @ConstructorProperties(value={"wanEventStore", "configUpdateEventStore", "diagnosticsConfigUpdatedEventStore"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EventGroupingVisitor(WanEventStore wanEventStore, ConfigUpdateEventStore configUpdateEventStore, DiagnosticsConfigUpdatedEventStore diagnosticsConfigUpdatedEventStore) {
        this.wanEventStore = wanEventStore;
        this.configUpdateEventStore = configUpdateEventStore;
        this.diagnosticsConfigUpdatedEventStore = diagnosticsConfigUpdatedEventStore;
    }
}

