/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/security"})
@Profile(value={"!hzcloud"})
public class SecurityConfigController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfigController.class);
    private final AuthenticationManagerImpl authenticationManager;

    @GetMapping(value={"/currentProvider"})
    public String getCurrentProviderName() {
        return this.authenticationManager.getCurrentSecurityProviderName();
    }

    @GetMapping(value={"/configured"})
    public boolean isConfigured() {
        return this.authenticationManager.isSecurityProviderConfigured();
    }

    @GetMapping(value={"/reloadConfigAvailable"})
    public boolean isReloadConfigAvailable() {
        return this.authenticationManager.isReloadSecurityConfigAvailable();
    }

    @GetMapping(value={"/providers"})
    public List<String> getProviders() {
        return this.authenticationManager.getSecurityProviders();
    }

    @PostMapping(value={"/reloadConfig"})
    public boolean reloadConfig() {
        try {
            this.authenticationManager.reloadSecurityConfig();
        }
        catch (SecurityConfigApiException e) {
            log.warn("Failed to reload security configuration", (Throwable)e);
            return false;
        }
        return true;
    }

    @PostMapping(value={"/createConfig"}, produces={"application/json"})
    public void saveConfig(HttpServletRequest request) {
        try {
            this.authenticationManager.saveSecurityProviderConfig(request.getParameterMap());
        }
        catch (SecurityConfigApiException e) {
            log.warn("Failed to save security configuration", (Throwable)e);
            throw e;
        }
    }

    @PostMapping(value={"/updateConfig"}, produces={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public void updateConfig(HttpServletRequest request) {
        try {
            this.authenticationManager.updateSecurityProviderConfig(request.getParameterMap());
        }
        catch (SecurityConfigApiException e) {
            log.warn("Failed to save security configuration", (Throwable)e);
            throw e;
        }
    }

    @PostMapping(value={"/testConfig"})
    public String testConfig(@RequestParam(required=false) String testUsername, @RequestParam(required=false) String testPassword, HttpServletRequest req) {
        return this.authenticationManager.testSecurityProviderConfig(testUsername, testPassword, req.getParameterMap()).orElse(null);
    }

    @ConstructorProperties(value={"authenticationManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SecurityConfigController(AuthenticationManagerImpl authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

