/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.controller.dto.OidcConfiguration;
import com.hazelcast.webmonitor.controller.dto.OidcConfigurationDTO;
import com.hazelcast.webmonitor.controller.exception.FailureApiException;
import com.hazelcast.webmonitor.security.CustomAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticator;
import com.hazelcast.webmonitor.service.EndSessionEndpointFetchedEvent;
import com.hazelcast.webmonitor.session.SessionUtil;
import com.nimbusds.oauth2.sdk.ParseException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@Profile(value={"!hzcloud"})
public class OidcController {
    public static final String AUTH_CODE_ENDPOINT = "/oidc/auth";
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcController.class);
    @Autowired
    private RestTemplate restTemplate;
    private final OidcAuthenticator authenticator;
    private final CustomAuthenticationFailureHandler authFailureHandler;
    private final ApplicationEventPublisher publisher;

    public OidcController(OidcAuthenticator authenticator, CustomAuthenticationFailureHandler authFailureHandler, ApplicationEventPublisher publisher) {
        this.authenticator = authenticator;
        this.authFailureHandler = authFailureHandler;
        this.publisher = publisher;
    }

    @PostMapping(value={"/oidc/sso"}, produces={"text/html; charset=utf-8"})
    public void sso(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException {
        String url = this.authenticator.generateAuthenticationRequestURL(session);
        LOGGER.debug("Redirecting user to authentication request URL {}.", (Object)url);
        SessionUtil.tryInvalidateRedirectUrl((HttpSession)session, (String)request.getQueryString());
        response.sendRedirect(url);
    }

    @GetMapping(value={"/oidc/auth"}, produces={"text/html; charset=utf-8"})
    public void handleAuthCode(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ParseException, URISyntaxException, IOException {
        URI requestURI = new URI(request.getRequestURL().toString() + "?" + request.getQueryString());
        try {
            String username = this.authenticator.completeAuthentication(session, requestURI);
            LOGGER.debug("Authenticated user {} via OpenID Connect.", (Object)username);
            response.sendRedirect(request.getContextPath() + SessionUtil.extractRedirectUrl((HttpSession)request.getSession()));
        }
        catch (AuthenticationException e) {
            this.authFailureHandler.onAuthenticationFailure(request, response, e);
        }
    }

    @GetMapping(value={"/oidc/config"})
    public OidcConfigurationDTO getOIDCConfigByIssuer(@RequestParam String issuer) throws FailureApiException {
        try {
            OidcConfiguration oidcConfiguration = (OidcConfiguration)this.restTemplate.getForObject(issuer, OidcConfiguration.class, new Object[0]);
            if (oidcConfiguration == null || oidcConfiguration.getUserInfoEndpoint() == null || oidcConfiguration.getAuthorizationEndpoint() == null || oidcConfiguration.getJwksUri() == null || oidcConfiguration.getTokenEndpoint() == null) {
                throw new FailureApiException("Configuration does not have all required fields");
            }
            if (oidcConfiguration.getEndSessionEndpoint() != null) {
                this.publisher.publishEvent((ApplicationEvent)new EndSessionEndpointFetchedEvent(oidcConfiguration.getEndSessionEndpoint()));
            }
            return OidcConfigurationDTO.fromOidcConfiguration((OidcConfiguration)oidcConfiguration);
        }
        catch (Exception e) {
            throw new FailureApiException(e.getMessage());
        }
    }
}

