/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.CacheThroughputStatsDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientsNearCacheIntervalStatsDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.CacheManager;
import com.hazelcast.webmonitor.service.DataStructureStatsService;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.List;
import java.util.Map;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
public class CacheController
extends BaseInternalController {
    private final CacheManager cacheManager;
    private final DataStructureStatsService statsService;

    public CacheController(CacheManager cacheManager, DataStructureStatsService statsService, StateManager stateManager, AuditLogService auditService) {
        super(stateManager, auditService);
        this.cacheManager = cacheManager;
        this.statsService = statsService;
    }

    @GetMapping(path={"/clusters/{cluster}/caches/{cache}/nearCache/clients/summaryStats"})
    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(@PathVariable String cluster, @PathVariable String cache, @RequestParam(defaultValue="0") long time) {
        return this.cacheManager.getClientsNearCacheSummaryStats(cluster, cache, time);
    }

    @GetMapping(value={"/clusters/{cluster}/caches/{cache}/throughputStats"})
    public List<CacheThroughputStatsDTO> getCacheThroughputStats(@PathVariable String cluster, @PathVariable String cache, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return this.statsService.getCacheThroughputStats(cluster, cache, time, interval);
    }

    @GetMapping(value={"/clusters/{cluster}/caches/{cache}/content/{keyType}/{key}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER"})
    public Map<String, String> browseCache(@PathVariable(value="cluster") String clusterName, @PathVariable(value="cache") String cacheName, @PathVariable(value="keyType") String keyType, @PathVariable(value="key") String key) {
        return (Map)this.executeOperation(() -> this.cacheManager.getCacheEntry(clusterName, keyType, cacheName, key), this.operationLogBuilder("MC-5001 [Browser]", "Cache was browsed by user").parameter("cluster", (Object)clusterName).parameter("cache", (Object)cacheName).parameter("key", (Object)key));
    }
}

