/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.dto;

import com.hazelcast.webmonitor.controller.dto.ClusterDTO;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import lombok.Generated;

public class ClusterDTO {
    private String name;
    private List<String> memberAddresses;
    private ClientConfigType clientConfigType;
    private String clientConfig;
    private boolean enabled;

    public static ClusterDTO fromModel(ClusterModel cluster) {
        ClusterDTO dto = new ClusterDTO();
        dto.setName(cluster.getName());
        dto.setEnabled(cluster.isEnabled());
        if (cluster.getMemberAddresses() != null) {
            dto.setMemberAddresses(List.of(cluster.getMemberAddresses()));
        }
        if (cluster.getClientConfigType() != null) {
            switch (1.$SwitchMap$com$hazelcast$webmonitor$model$sql$ClusterModel$ClientConfigType[cluster.getClientConfigType().ordinal()]) {
                case 1: {
                    dto.setClientConfigType(ClientConfigType.XML);
                    break;
                }
                case 2: {
                    dto.setClientConfigType(ClientConfigType.YAML);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported client config type: " + String.valueOf(cluster.getClientConfigType()));
                }
            }
        }
        dto.setClientConfig(cluster.getClientConfig());
        return dto;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterDTO() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<String> getMemberAddresses() {
        return this.memberAddresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientConfigType getClientConfigType() {
        return this.clientConfigType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientConfig() {
        return this.clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMemberAddresses(List<String> memberAddresses) {
        this.memberAddresses = memberAddresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientConfigType(ClientConfigType clientConfigType) {
        this.clientConfigType = clientConfigType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterDTO)) {
            return false;
        }
        ClusterDTO other = (ClusterDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$memberAddresses = this.getMemberAddresses();
        List other$memberAddresses = other.getMemberAddresses();
        if (this$memberAddresses == null ? other$memberAddresses != null : !((Object)this$memberAddresses).equals(other$memberAddresses)) {
            return false;
        }
        ClientConfigType this$clientConfigType = this.getClientConfigType();
        ClientConfigType other$clientConfigType = other.getClientConfigType();
        if (this$clientConfigType == null ? other$clientConfigType != null : !this$clientConfigType.equals(other$clientConfigType)) {
            return false;
        }
        String this$clientConfig = this.getClientConfig();
        String other$clientConfig = other.getClientConfig();
        return !(this$clientConfig == null ? other$clientConfig != null : !this$clientConfig.equals(other$clientConfig));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClusterDTO;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $memberAddresses = this.getMemberAddresses();
        result = result * 59 + ($memberAddresses == null ? 43 : ((Object)$memberAddresses).hashCode());
        ClientConfigType $clientConfigType = this.getClientConfigType();
        result = result * 59 + ($clientConfigType == null ? 43 : $clientConfigType.hashCode());
        String $clientConfig = this.getClientConfig();
        result = result * 59 + ($clientConfig == null ? 43 : $clientConfig.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ClusterDTO(name=" + this.getName() + ", memberAddresses=" + String.valueOf(this.getMemberAddresses()) + ", clientConfigType=" + String.valueOf(this.getClientConfigType()) + ", clientConfig=" + this.getClientConfig() + ", enabled=" + this.isEnabled() + ")";
    }
}

