/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.ee11.servlet.ServletHandler;
import org.eclipse.jetty.ee11.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.jetty.JettyServerCustomizer;
import org.springframework.boot.jetty.autoconfigure.JettyServerProperties;
import org.springframework.boot.jetty.servlet.JettyServletWebServerFactory;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

@Component
@ConditionalOnClass(value={Server.class, Loader.class, WebAppContext.class})
public class MCJettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<JettyServletWebServerFactory>,
Ordered {
    public static final int ORDER = 100;
    private static final Set<String> TLS_PROTOCOLS = Set.of("SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "SSLv2Hello");
    private final MCConfigurationProperties mcProperties;
    private final JettyServerProperties serverProperties;

    public int getOrder() {
        return 100;
    }

    public void customize(JettyServletWebServerFactory factory) {
        factory.setUseForwardHeaders(this.mcProperties.isForwardedRequestsEnabled());
        MCConfigurationProperties.TLS tls = this.mcProperties.getTls();
        InetSocketAddress address = new InetSocketAddress(this.mcProperties.getHostAddress(), this.mcProperties.getPort());
        factory.setAddress(address.getAddress());
        factory.setPort(address.getPort());
        if (tls.isEnabled()) {
            factory.addServerCustomizers(new JettyServerCustomizer[]{server -> this.addSSLConnector(address, server)});
            if (tls.isEnableHttpPort()) {
                factory.addServerCustomizers(new JettyServerCustomizer[]{server -> this.addSeparateHttpPortConnectorForMC(address, server)});
            }
        }
        factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            server.getContainedBeans(ServletHandler.class).forEach(it -> it.setDecodeAmbiguousURIs(true));
            for (Connector connector : server.getConnectors()) {
                HttpConfiguration httpConfiguration = ((HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
                httpConfiguration.setUriCompliance(UriCompliance.from(EnumSet.of(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR)));
                httpConfiguration.setRelativeRedirectAllowed(false);
            }
        }});
    }

    private void addSSLConnector(InetSocketAddress address, Server server) {
        ServerConnector connector = new ServerConnector(server, this.createSslContextFactory(server));
        connector.setIdleTimeout(this.serverProperties.getConnectionIdleTimeout().toMillis());
        connector.setPort(address.getPort());
        connector.setHost(address.getHostString());
        connector.setName("SecuredWebApp");
        if (!this.mcProperties.getTls().isSniHostCheckEnabled()) {
            HttpConnectionFactory connectionFactory = (HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class);
            ((SecureRequestCustomizer)connectionFactory.getHttpConfiguration().getCustomizer(SecureRequestCustomizer.class)).setSniHostCheck(false);
        }
        server.setConnectors(new Connector[]{connector});
    }

    private void addSeparateHttpPortConnectorForMC(InetSocketAddress address, Server server) {
        HttpConfiguration config = new HttpConfiguration();
        config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        config.setSecureScheme(HttpScheme.HTTPS.asString());
        config.setSecurePort(this.mcProperties.getHttpsPort());
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setIdleTimeout(this.serverProperties.getConnectionIdleTimeout().toMillis());
        connector.setPort(this.mcProperties.getHttpPort());
        connector.setHost(address.getHostString());
        connector.setName("WebApp");
        server.addConnector((Connector)connector);
        server.insertHandler((Handler.Singleton)new SecuredRedirectHandler());
    }

    public SslContextFactory.Server createSslContextFactory(Server server) {
        SslContextFactory.Server factory = new SslContextFactory.Server();
        MCConfigurationProperties.TLS tls = this.mcProperties.getTls();
        String keyStore = tls.getKeyStore();
        try {
            URL url = ResourceUtils.getURL((String)keyStore);
            factory.setKeyStoreResource(ResourceFactory.of((Container)server).newResource(url));
        }
        catch (Exception ex) {
            throw new WebServerException("Could not load key store '" + keyStore + "'", (Throwable)ex);
        }
        factory.setKeyStorePassword(tls.getKeyStorePassword());
        factory.setKeyManagerFactoryAlgorithm(tls.getKeyManagerAlgorithm());
        String trustStore = tls.getTrustStore();
        if (trustStore != null) {
            try {
                URL url = ResourceUtils.getURL((String)trustStore);
                factory.setTrustStoreResource(ResourceFactory.of((Container)server).newResource(url));
            }
            catch (Exception ex) {
                throw new WebServerException("Could not load trust store '" + trustStore + "'", (Throwable)ex);
            }
        }
        Optional.ofNullable(tls.getTrustStorePassword()).ifPresent(arg_0 -> ((SslContextFactory.Server)factory).setTrustStorePassword(arg_0));
        factory.setTrustManagerFactoryAlgorithm(tls.getTrustManagerAlgorithm());
        factory.setProtocol(tls.getProtocol());
        String mutualAuthentication = tls.getMutualAuthentication();
        if (mutualAuthentication != null) {
            if (mutualAuthentication.equals("REQUIRED")) {
                factory.setNeedClientAuth(true);
            } else if (mutualAuthentication.equals("OPTIONAL")) {
                factory.setWantClientAuth(true);
            }
        }
        if (!tls.getExcludeProtocols().isEmpty()) {
            List protocols = tls.getExcludeProtocols();
            String[] excludedProtocols = new String[protocols.size()];
            for (int i = 0; i < protocols.size(); ++i) {
                String excludedProtocol = ((String)protocols.get(i)).trim();
                if (!TLS_PROTOCOLS.contains(excludedProtocol)) {
                    throw new IllegalArgumentException("Excluded protocol [" + excludedProtocol + "] does not exist - no need to exclude it.");
                }
                excludedProtocols[i] = excludedProtocol;
            }
            factory.setExcludeProtocols(excludedProtocols);
        }
        if (tls.isOpenSsl()) {
            Security.addProvider((Provider)new OpenSSLProvider());
            factory.setProvider("Conscrypt");
        }
        Optional.ofNullable(this.mcProperties.getIncludeCipherSuites()).ifPresent(arg_0 -> ((SslContextFactory.Server)factory).setIncludeCipherSuites(arg_0));
        Optional.ofNullable(this.mcProperties.getExcludeCipherSuites()).ifPresent(arg_0 -> ((SslContextFactory.Server)factory).setExcludeCipherSuites(arg_0));
        return factory;
    }

    @ConstructorProperties(value={"mcProperties", "serverProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MCJettyWebServerFactoryCustomizer(MCConfigurationProperties mcProperties, JettyServerProperties serverProperties) {
        this.mcProperties = mcProperties;
        this.serverProperties = serverProperties;
    }
}

