/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.config.properties.CloudSQLWizardConfigurationProperties;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.MediaType;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@Configuration
@Profile(value={"hzcloud"})
@EnableConfigurationProperties(value={CloudSQLWizardConfigurationProperties.class})
public class CloudConfig {
    @Bean
    public RestTemplate cloudSqlWizardRestTemplate(CloudSQLWizardConfigurationProperties sqlWizardProperties) {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(SerializationUtil.OBJECT_MAPPER);
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(converter.getSupportedMediaTypes());
        mediaTypes.add(MediaType.TEXT_PLAIN);
        converter.setSupportedMediaTypes(mediaTypes);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(0, converter);
        if (ObjectUtils.allNotNull((Object[])new Object[]{sqlWizardProperties.getUsername(), sqlWizardProperties.getPassword()})) {
            restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(sqlWizardProperties.getUsername(), sqlWizardProperties.getPassword()));
        }
        return restTemplate;
    }
}

