/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.csv.impl;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.file.CsvFileFormat;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.impl.ReadFileFnProvider;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.MappingIterator;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectReader;
import com.hazelcast.shaded.com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.hazelcast.shaded.com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.hazelcast.shaded.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="The FileInputStream is closed via Stream$onClose")
public class CsvReadFileFnProvider
implements ReadFileFnProvider {
    @Nonnull
    public <T> FunctionEx<Path, Stream<T>> createReadFileFn(@Nonnull FileFormat<T> format) {
        CsvFileFormat csvFileFormat = (CsvFileFormat)format;
        Class formatClazz = csvFileFormat.clazz();
        return (FunctionEx & Serializable)path -> {
            MappingIterator iterator;
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            Function projection = Function.identity();
            if (formatClazz == String[].class) {
                ObjectReader reader = new CsvMapper().enable(CsvParser.Feature.WRAP_AS_ARRAY).readerFor(String[].class).with(CsvParser.Feature.SKIP_EMPTY_LINES).with(CsvSchema.emptySchema().withSkipFirstDataRow(false));
                iterator = reader.readValues(inputStream);
                if (!iterator.hasNext()) {
                    throw new JetException("Header row missing in " + String.valueOf(path));
                }
                String[] header = (String[])iterator.next();
                List fieldNames = csvFileFormat.fieldNames();
                if (fieldNames != null) {
                    projection = Util.createFieldProjection((String[])header, (List)fieldNames);
                }
            } else {
                iterator = new CsvMapper().readerFor(formatClazz).withoutFeatures(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).with(CsvParser.Feature.SKIP_EMPTY_LINES).with(CsvSchema.emptySchema().withHeader()).readValues(inputStream);
            }
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(projection).onClose(() -> Util.uncheckRun(inputStream::close));
        };
    }

    @Nonnull
    public String format() {
        return "csv";
    }
}

