/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.StandardServletAsyncWebRequest;
import org.springframework.web.context.request.async.WebAsyncManager;

public abstract class WebAsyncUtils {
    public static final String WEB_ASYNC_MANAGER_ATTRIBUTE = WebAsyncManager.class.getName() + ".WEB_ASYNC_MANAGER";

    public static WebAsyncManager getAsyncManager(ServletRequest servletRequest) {
        WebAsyncManager asyncManager = null;
        Object asyncManagerAttr = servletRequest.getAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE);
        if (asyncManagerAttr instanceof WebAsyncManager) {
            WebAsyncManager wam;
            asyncManager = wam = (WebAsyncManager)asyncManagerAttr;
        }
        if (asyncManager == null) {
            asyncManager = new WebAsyncManager();
            servletRequest.setAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE, asyncManager);
        }
        return asyncManager;
    }

    public static WebAsyncManager getAsyncManager(WebRequest webRequest) {
        int scope = 0;
        WebAsyncManager asyncManager = null;
        Object asyncManagerAttr = webRequest.getAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE, scope);
        if (asyncManagerAttr instanceof WebAsyncManager) {
            WebAsyncManager wam;
            asyncManager = wam = (WebAsyncManager)asyncManagerAttr;
        }
        if (asyncManager == null) {
            asyncManager = new WebAsyncManager();
            webRequest.setAttribute(WEB_ASYNC_MANAGER_ATTRIBUTE, asyncManager, scope);
        }
        return asyncManager;
    }

    public static AsyncWebRequest createAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
        StandardServletAsyncWebRequest standardServletAsyncWebRequest;
        AsyncWebRequest prev = WebAsyncUtils.getAsyncManager(request).getAsyncWebRequest();
        if (prev instanceof StandardServletAsyncWebRequest) {
            StandardServletAsyncWebRequest standardRequest = (StandardServletAsyncWebRequest)prev;
            standardServletAsyncWebRequest = new StandardServletAsyncWebRequest(request, response, standardRequest);
        } else {
            standardServletAsyncWebRequest = new StandardServletAsyncWebRequest(request, response);
        }
        return standardServletAsyncWebRequest;
    }
}

