/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.JettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.support.JettyHeadersAdapter;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JettyCoreServerHttpResponse
extends AbstractServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private final Response response;

    public JettyCoreServerHttpResponse(Response response, JettyDataBufferFactory dataBufferFactory) {
        super(dataBufferFactory, new HttpHeaders(new JettyHeadersAdapter((HttpFields)response.getHeaders())));
        this.response = response;
        ListIterator it = this.response.getHeaders().listIterator();
        while (it.hasNext()) {
            HttpField field = (HttpField)it.next();
            if (!(field instanceof HttpCookieUtils.SetCookieHttpField)) continue;
            HttpCookieUtils.SetCookieHttpField setCookieHttpField = (HttpCookieUtils.SetCookieHttpField)field;
            HttpCookie httpCookie = setCookieHttpField.getHttpCookie();
            ResponseCookie responseCookie = ResponseCookie.from(httpCookie.getName(), httpCookie.getValue()).httpOnly(httpCookie.isHttpOnly()).domain(httpCookie.getDomain()).maxAge(httpCookie.getMaxAge()).sameSite(httpCookie.getSameSite().name()).secure(httpCookie.isSecure()).partitioned(httpCookie.isPartitioned()).build();
            this.addCookie(responseCookie);
            it.remove();
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<? extends DataBuffer> body2) {
        return Flux.from(body2).concatMap(this::sendDataBuffer).then();
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        return Flux.from(body2).concatMap(this::writeWithInternal).then();
    }

    @Override
    protected void applyStatusCode() {
        HttpStatusCode status = this.getStatusCode();
        if (status != null) {
            this.response.setStatus(status.value());
        }
    }

    @Override
    protected void applyHeaders() {
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).forEach(cookie -> Response.addCookie((Response)this.response, (HttpCookie)new ResponseHttpCookie((ResponseCookie)cookie)));
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count) {
        Callback.Completable callback = new Callback.Completable();
        Mono mono = Mono.fromFuture((CompletableFuture)callback);
        try {
            Content.copy((Content.Source)Content.Source.from(null, (Path)file, (long)position, (long)count), (Content.Sink)this.response, (Callback)callback);
        }
        catch (Throwable th) {
            callback.failed(th);
        }
        return this.doCommit(() -> mono);
    }

    private Mono<Void> sendDataBuffer(final DataBuffer dataBuffer) {
        return Mono.defer(() -> {
            final DataBuffer.ByteBufferIterator byteBufferIterator = dataBuffer.readableByteBuffers();
            final Callback.Completable callback = new Callback.Completable();
            new IteratingCallback(){

                protected IteratingCallback.Action process() {
                    if (!byteBufferIterator.hasNext()) {
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    JettyCoreServerHttpResponse.this.response.write(false, (ByteBuffer)byteBufferIterator.next(), (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }

                protected void onCompleteSuccess() {
                    byteBufferIterator.close();
                    DataBufferUtils.release(dataBuffer);
                    callback.complete(null);
                }

                protected void onCompleteFailure(Throwable cause) {
                    byteBufferIterator.close();
                    DataBufferUtils.release(dataBuffer);
                    callback.failed(cause);
                }
            }.iterate();
            return Mono.fromFuture((CompletableFuture)callback);
        });
    }

    @Override
    public <T> T getNativeResponse() {
        return (T)this.response;
    }

    private static class ResponseHttpCookie
    implements HttpCookie {
        private final ResponseCookie responseCookie;

        ResponseHttpCookie(ResponseCookie responseCookie) {
            this.responseCookie = responseCookie;
        }

        public String getName() {
            return this.responseCookie.getName();
        }

        public String getValue() {
            return this.responseCookie.getValue();
        }

        public int getVersion() {
            return 0;
        }

        public long getMaxAge() {
            return this.responseCookie.getMaxAge().toSeconds();
        }

        @Nullable
        public String getComment() {
            return null;
        }

        @Nullable
        public String getDomain() {
            return this.responseCookie.getDomain();
        }

        @Nullable
        public String getPath() {
            return this.responseCookie.getPath();
        }

        public boolean isSecure() {
            return this.responseCookie.isSecure();
        }

        @Nullable
        public HttpCookie.SameSite getSameSite() {
            return null;
        }

        public boolean isHttpOnly() {
            return this.responseCookie.isHttpOnly();
        }

        public boolean isPartitioned() {
            return this.responseCookie.isPartitioned();
        }

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }
    }
}

