/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.metrics.exporter.pushgateway.PushGateway;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class PrometheusPushGatewayManager {
    private static final Log logger = LogFactory.getLog(PrometheusPushGatewayManager.class);
    private final PushGateway pushGateway;
    private final ShutdownOperation shutdownOperation;
    private final TaskScheduler scheduler;
    private final ScheduledFuture<?> scheduled;

    public PrometheusPushGatewayManager(PushGateway pushGateway, Duration pushRate, ShutdownOperation shutdownOperation) {
        this(pushGateway, new PushGatewayTaskScheduler(), pushRate, shutdownOperation);
    }

    PrometheusPushGatewayManager(PushGateway pushGateway, TaskScheduler scheduler, Duration pushRate, ShutdownOperation shutdownOperation) {
        Assert.notNull((Object)pushGateway, "'pushGateway' must not be null");
        Assert.notNull((Object)scheduler, "'scheduler' must not be null");
        Assert.notNull((Object)pushRate, "'pushRate' must not be null");
        this.pushGateway = pushGateway;
        this.shutdownOperation = shutdownOperation != null ? shutdownOperation : ShutdownOperation.NONE;
        this.scheduler = scheduler;
        this.scheduled = this.scheduler.scheduleAtFixedRate(this::post, pushRate);
    }

    private void post() {
        try {
            this.pushGateway.pushAdd();
        }
        catch (Throwable ex) {
            logger.warn("Unexpected exception thrown by POST of metrics to Prometheus Pushgateway", ex);
        }
    }

    private void put() {
        try {
            this.pushGateway.push();
        }
        catch (Throwable ex) {
            logger.warn("Unexpected exception thrown by PUT of metrics to Prometheus Pushgateway", ex);
        }
    }

    private void delete() {
        try {
            this.pushGateway.delete();
        }
        catch (Throwable ex) {
            logger.warn("Unexpected exception thrown by DELETE of metrics from Prometheus Pushgateway", ex);
        }
    }

    public void shutdown() {
        this.shutdown(this.shutdownOperation);
    }

    private void shutdown(ShutdownOperation shutdownOperation) {
        TaskScheduler taskScheduler = this.scheduler;
        if (taskScheduler instanceof PushGatewayTaskScheduler) {
            PushGatewayTaskScheduler pushGatewayTaskScheduler = (PushGatewayTaskScheduler)taskScheduler;
            pushGatewayTaskScheduler.shutdown();
        }
        this.scheduled.cancel(false);
        switch (shutdownOperation) {
            case POST: {
                this.post();
                break;
            }
            case PUT: {
                this.put();
                break;
            }
            case DELETE: {
                this.delete();
            }
        }
    }

    static class PushGatewayTaskScheduler
    extends ThreadPoolTaskScheduler {
        PushGatewayTaskScheduler() {
            this.setPoolSize(1);
            this.setDaemon(true);
            this.setThreadGroupName("prometheus-push-gateway");
        }

        @Override
        public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
            return Executors.newSingleThreadScheduledExecutor(this::newThread);
        }
    }

    public static enum ShutdownOperation {
        NONE,
        POST,
        PUT,
        DELETE;

    }
}

