/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.OperationFilter;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredOperationMethod;
import org.springframework.boot.actuate.endpoint.annotation.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvoker;
import org.springframework.boot.actuate.endpoint.invoke.OperationInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.invoke.ParameterValueMapper;
import org.springframework.boot.actuate.endpoint.web.AdditionalPathsMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.PathMapper;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.annotation.DiscoveredWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.annotation.DiscoveredWebOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.RequestPredicateFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ImportRuntimeHints;

@ImportRuntimeHints(value={WebEndpointDiscovererRuntimeHints.class})
public class WebEndpointDiscoverer
extends EndpointDiscoverer<ExposableWebEndpoint, WebOperation>
implements WebEndpointsSupplier {
    private final List<PathMapper> endpointPathMappers;
    private final List<AdditionalPathsMapper> additionalPathsMappers;
    private final RequestPredicateFactory requestPredicateFactory;

    @Deprecated(since="3.4.0", forRemoval=true)
    public WebEndpointDiscoverer(ApplicationContext applicationContext, ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, List<PathMapper> endpointPathMappers, Collection<OperationInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<ExposableWebEndpoint>> filters) {
        this(applicationContext, parameterValueMapper, endpointMediaTypes, endpointPathMappers, Collections.emptyList(), invokerAdvisors, filters, Collections.emptyList());
    }

    public WebEndpointDiscoverer(ApplicationContext applicationContext, ParameterValueMapper parameterValueMapper, EndpointMediaTypes endpointMediaTypes, List<PathMapper> endpointPathMappers, List<AdditionalPathsMapper> additionalPathsMappers, Collection<OperationInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<ExposableWebEndpoint>> endpointFilters, Collection<OperationFilter<WebOperation>> operationFilters) {
        super(applicationContext, parameterValueMapper, invokerAdvisors, endpointFilters, operationFilters);
        this.endpointPathMappers = endpointPathMappers != null ? endpointPathMappers : Collections.emptyList();
        this.additionalPathsMappers = additionalPathsMappers != null ? additionalPathsMappers : Collections.emptyList();
        this.requestPredicateFactory = new RequestPredicateFactory(endpointMediaTypes);
    }

    @Override
    protected ExposableWebEndpoint createEndpoint(Object endpointBean, EndpointId id, Access defaultAccess, Collection<WebOperation> operations) {
        String rootPath = PathMapper.getRootPath(this.endpointPathMappers, id);
        return new DiscoveredWebEndpoint(this, endpointBean, id, rootPath, defaultAccess, operations, this.additionalPathsMappers);
    }

    @Override
    protected WebOperation createOperation(EndpointId endpointId, DiscoveredOperationMethod operationMethod, OperationInvoker invoker) {
        String rootPath = PathMapper.getRootPath(this.endpointPathMappers, endpointId);
        WebOperationRequestPredicate requestPredicate = this.requestPredicateFactory.getRequestPredicate(rootPath, operationMethod);
        return new DiscoveredWebOperation(endpointId, operationMethod, invoker, requestPredicate);
    }

    @Override
    protected EndpointDiscoverer.OperationKey createOperationKey(WebOperation operation) {
        return new EndpointDiscoverer.OperationKey(operation.getRequestPredicate(), () -> "web request predicate " + String.valueOf(operation.getRequestPredicate()));
    }

    static class WebEndpointDiscovererRuntimeHints
    implements RuntimeHintsRegistrar {
        WebEndpointDiscovererRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(WebEndpointFilter.class, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        }
    }
}

