/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.PathMappedEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class PathMappedEndpoints
implements Iterable<PathMappedEndpoint> {
    private final String basePath;
    private final Map<EndpointId, PathMappedEndpoint> endpoints;

    public PathMappedEndpoints(String basePath, EndpointsSupplier<?> supplier) {
        Assert.notNull(supplier, "'supplier' must not be null");
        this.basePath = basePath != null ? basePath : "";
        this.endpoints = this.getEndpoints(Collections.singleton(supplier));
    }

    public PathMappedEndpoints(String basePath, Collection<EndpointsSupplier<?>> suppliers) {
        Assert.notNull(suppliers, "'suppliers' must not be null");
        this.basePath = basePath != null ? basePath : "";
        this.endpoints = this.getEndpoints(suppliers);
    }

    private Map<EndpointId, PathMappedEndpoint> getEndpoints(Collection<EndpointsSupplier<?>> suppliers) {
        LinkedHashMap endpoints = new LinkedHashMap();
        suppliers.forEach(supplier -> supplier.getEndpoints().forEach(endpoint -> {
            if (endpoint instanceof PathMappedEndpoint) {
                PathMappedEndpoint pathMappedEndpoint = (PathMappedEndpoint)((Object)endpoint);
                endpoints.put(endpoint.getEndpointId(), pathMappedEndpoint);
            }
        }));
        return Collections.unmodifiableMap(endpoints);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getRootPath(EndpointId endpointId) {
        PathMappedEndpoint endpoint = this.getEndpoint(endpointId);
        return endpoint != null ? endpoint.getRootPath() : null;
    }

    public String getPath(EndpointId endpointId) {
        return this.getPath(this.getEndpoint(endpointId));
    }

    public Collection<String> getAllRootPaths() {
        return this.stream().map(PathMappedEndpoint::getRootPath).toList();
    }

    public Collection<String> getAllPaths() {
        return this.stream().map(this::getPath).toList();
    }

    public Collection<String> getAdditionalPaths(WebServerNamespace webServerNamespace, EndpointId endpointId) {
        return this.getAdditionalPaths(webServerNamespace, this.getEndpoint(endpointId)).toList();
    }

    private Stream<String> getAdditionalPaths(WebServerNamespace webServerNamespace, PathMappedEndpoint endpoint) {
        List<String> additionalPaths;
        List<String> list = additionalPaths = endpoint != null ? endpoint.getAdditionalPaths(webServerNamespace) : null;
        if (CollectionUtils.isEmpty(additionalPaths)) {
            return Stream.empty();
        }
        return additionalPaths.stream().map(this::getAdditionalPath);
    }

    private String getAdditionalPath(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    public PathMappedEndpoint getEndpoint(EndpointId endpointId) {
        return this.endpoints.get(endpointId);
    }

    public Stream<PathMappedEndpoint> stream() {
        return this.endpoints.values().stream();
    }

    @Override
    public Iterator<PathMappedEndpoint> iterator() {
        return this.endpoints.values().iterator();
    }

    private String getPath(PathMappedEndpoint endpoint) {
        if (endpoint == null) {
            return null;
        }
        StringBuilder path = new StringBuilder(this.basePath);
        if (!this.basePath.equals("/")) {
            path.append("/");
        }
        if (!endpoint.getRootPath().equals("/")) {
            path.append(endpoint.getRootPath());
        }
        return path.toString();
    }
}

