/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.annotation;

import java.util.Collection;
import org.springframework.boot.actuate.endpoint.AbstractExposableEndpoint;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.annotation.DiscoveredEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointDiscoverer;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public abstract class AbstractDiscoveredEndpoint<O extends Operation>
extends AbstractExposableEndpoint<O>
implements DiscoveredEndpoint<O> {
    private final EndpointDiscoverer<?, ?> discoverer;
    private final Object endpointBean;

    @Deprecated(since="3.4.0", forRemoval=true)
    public AbstractDiscoveredEndpoint(EndpointDiscoverer<?, ?> discoverer, Object endpointBean, EndpointId id, boolean enabledByDefault, Collection<? extends O> operations) {
        this(discoverer, endpointBean, id, enabledByDefault ? Access.UNRESTRICTED : Access.READ_ONLY, operations);
    }

    public AbstractDiscoveredEndpoint(EndpointDiscoverer<?, ?> discoverer, Object endpointBean, EndpointId id, Access defaultAccess, Collection<? extends O> operations) {
        super(id, defaultAccess, operations);
        Assert.notNull(discoverer, "'discoverer' must not be null");
        Assert.notNull(endpointBean, "'endpointBean' must not be null");
        this.discoverer = discoverer;
        this.endpointBean = endpointBean;
    }

    @Override
    public Object getEndpointBean() {
        return this.endpointBean;
    }

    @Override
    public boolean wasDiscoveredBy(Class<? extends EndpointDiscoverer<?, ?>> discoverer) {
        return discoverer.isInstance(this.discoverer);
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this).append("discoverer", this.discoverer.getClass().getName()).append("endpointBean", this.endpointBean.getClass().getName());
        this.appendFields(creator);
        return creator.toString();
    }

    protected void appendFields(ToStringCreator creator) {
    }
}

