/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.servlet;

import jakarta.servlet.Filter;
import java.io.File;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementWebServerFactoryCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.util.StringUtils;

@ManagementContextConfiguration(value=ManagementContextType.CHILD, proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class ServletManagementChildContextConfiguration {
    ServletManagementChildContextConfiguration() {
    }

    @Bean
    ServletManagementWebServerFactoryCustomizer servletManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
        return new ServletManagementWebServerFactoryCustomizer(beanFactory);
    }

    @Bean
    @ConditionalOnClass(name={"io.undertow.Undertow"})
    UndertowAccessLogCustomizer undertowManagementAccessLogCustomizer(ManagementServerProperties properties) {
        return new UndertowAccessLogCustomizer(properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.valves.AccessLogValve"})
    TomcatAccessLogCustomizer tomcatManagementAccessLogCustomizer(ManagementServerProperties properties) {
        return new TomcatAccessLogCustomizer(properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.eclipse.jetty.server.Server"})
    JettyAccessLogCustomizer jettyManagementAccessLogCustomizer(ManagementServerProperties properties) {
        return new JettyAccessLogCustomizer(properties);
    }

    static class ServletManagementWebServerFactoryCustomizer
    extends ManagementWebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
        ServletManagementWebServerFactoryCustomizer(ListableBeanFactory beanFactory) {
            super(beanFactory);
        }

        @Override
        protected void customize(ConfigurableServletWebServerFactory webServerFactory, ManagementServerProperties managementServerProperties, ServerProperties serverProperties) {
            super.customize(webServerFactory, managementServerProperties, serverProperties);
            webServerFactory.setContextPath(this.getContextPath(managementServerProperties));
        }

        private String getContextPath(ManagementServerProperties managementServerProperties) {
            String basePath = managementServerProperties.getBasePath();
            return StringUtils.hasText(basePath) ? basePath : "";
        }
    }

    static class UndertowAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
        UndertowAccessLogCustomizer(ManagementServerProperties properties) {
            super(properties.getUndertow().getAccesslog().getPrefix());
        }

        @Override
        public void customize(UndertowServletWebServerFactory factory) {
            factory.setAccessLogPrefix(this.customizePrefix(factory.getAccessLogPrefix()));
        }
    }

    static class TomcatAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<TomcatServletWebServerFactory> {
        TomcatAccessLogCustomizer(ManagementServerProperties properties) {
            super(properties.getTomcat().getAccesslog().getPrefix());
        }

        @Override
        public void customize(TomcatServletWebServerFactory factory) {
            AccessLogValve accessLogValve = this.findAccessLogValve(factory);
            if (accessLogValve == null) {
                return;
            }
            accessLogValve.setPrefix(this.customizePrefix(accessLogValve.getPrefix()));
        }

        private AccessLogValve findAccessLogValve(TomcatServletWebServerFactory factory) {
            for (Valve engineValve : factory.getEngineValves()) {
                if (!(engineValve instanceof AccessLogValve)) continue;
                AccessLogValve accessLogValve = (AccessLogValve)engineValve;
                return accessLogValve;
            }
            return null;
        }
    }

    static class JettyAccessLogCustomizer
    extends AccessLogCustomizer
    implements WebServerFactoryCustomizer<JettyServletWebServerFactory> {
        JettyAccessLogCustomizer(ManagementServerProperties properties) {
            super(properties.getJetty().getAccesslog().getPrefix());
        }

        @Override
        public void customize(JettyServletWebServerFactory factory) {
            factory.addServerCustomizers(this::customizeServer);
        }

        private void customizeServer(Server server) {
            RequestLog requestLog = server.getRequestLog();
            if (requestLog instanceof CustomRequestLog) {
                CustomRequestLog customRequestLog = (CustomRequestLog)requestLog;
                this.customizeRequestLog(customRequestLog);
            }
        }

        private void customizeRequestLog(CustomRequestLog requestLog) {
            RequestLog.Writer writer = requestLog.getWriter();
            if (writer instanceof RequestLogWriter) {
                RequestLogWriter requestLogWriter = (RequestLogWriter)writer;
                this.customizeRequestLogWriter(requestLogWriter);
            }
        }

        private void customizeRequestLogWriter(RequestLogWriter writer) {
            String filename = writer.getFileName();
            if (StringUtils.hasLength(filename)) {
                File file = new File(filename);
                file = new File(file.getParentFile(), this.customizePrefix(file.getName()));
                writer.setFilename(file.getPath());
            }
        }
    }

    static abstract class AccessLogCustomizer
    implements Ordered {
        private final String prefix;

        AccessLogCustomizer(String prefix) {
            this.prefix = prefix;
        }

        protected String customizePrefix(String existingPrefix) {
            if (this.prefix == null) {
                return existingPrefix;
            }
            if (existingPrefix == null) {
                return this.prefix;
            }
            if (existingPrefix.startsWith(this.prefix)) {
                return existingPrefix;
            }
            return this.prefix + existingPrefix;
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.ANCESTORS)
    static class ServletManagementContextSecurityConfiguration {
        ServletManagementContextSecurityConfiguration() {
        }

        @Bean
        Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return parent.getBean("springSecurityFilterChain", Filter.class);
        }

        @Bean
        @ConditionalOnBean(name={"securityFilterChainRegistration"}, search=SearchStrategy.ANCESTORS)
        DelegatingFilterProxyRegistrationBean securityFilterChainRegistration(HierarchicalBeanFactory beanFactory) {
            return beanFactory.getParentBeanFactory().getBean("securityFilterChainRegistration", DelegatingFilterProxyRegistrationBean.class);
        }
    }
}

