/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnEnabledTracingCondition
extends SpringBootCondition {
    private static final String GLOBAL_PROPERTY = "management.tracing.enabled";
    private static final String EXPORTER_PROPERTY = "management.%s.tracing.export.enabled";

    OnEnabledTracingCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean exporterTracingEnabled;
        String tracingExporter = OnEnabledTracingCondition.getExporterName(metadata);
        if (StringUtils.hasLength(tracingExporter) && (exporterTracingEnabled = context.getEnvironment().getProperty(EXPORTER_PROPERTY.formatted(tracingExporter), Boolean.class)) != null) {
            return new ConditionOutcome((boolean)exporterTracingEnabled, ConditionMessage.forCondition(ConditionalOnEnabledTracing.class, new Object[0]).because(EXPORTER_PROPERTY.formatted(tracingExporter) + " is " + exporterTracingEnabled));
        }
        Boolean globalTracingEnabled = context.getEnvironment().getProperty(GLOBAL_PROPERTY, Boolean.class);
        if (globalTracingEnabled != null) {
            return new ConditionOutcome((boolean)globalTracingEnabled, ConditionMessage.forCondition(ConditionalOnEnabledTracing.class, new Object[0]).because("management.tracing.enabled is " + globalTracingEnabled));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnEnabledTracing.class, new Object[0]).because("tracing is enabled by default"));
    }

    private static String getExporterName(AnnotatedTypeMetadata metadata) {
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnEnabledTracing.class.getName());
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get("value");
    }
}

