/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.tracing;

import io.micrometer.common.annotation.ValueExpressionResolver;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.annotation.DefaultNewSpanParser;
import io.micrometer.tracing.annotation.ImperativeMethodInvocationProcessor;
import io.micrometer.tracing.annotation.MethodInvocationProcessor;
import io.micrometer.tracing.annotation.NewSpanParser;
import io.micrometer.tracing.annotation.SpanAspect;
import io.micrometer.tracing.annotation.SpanTagAnnotationHandler;
import io.micrometer.tracing.handler.DefaultTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingReceiverTracingObservationHandler;
import io.micrometer.tracing.handler.PropagatingSenderTracingObservationHandler;
import io.micrometer.tracing.propagation.Propagator;
import org.aspectj.weaver.Advice;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;

@AutoConfiguration
@ConditionalOnClass(value={Tracer.class})
@ConditionalOnBean(value={Tracer.class})
public class MicrometerTracingAutoConfiguration {
    public static final int DEFAULT_TRACING_OBSERVATION_HANDLER_ORDER = 2147482647;
    public static final int RECEIVER_TRACING_OBSERVATION_HANDLER_ORDER = 1000;
    public static final int SENDER_TRACING_OBSERVATION_HANDLER_ORDER = 2000;

    @Bean
    @ConditionalOnMissingBean
    @Order(value=2147482647)
    public DefaultTracingObservationHandler defaultTracingObservationHandler(Tracer tracer) {
        return new DefaultTracingObservationHandler(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Propagator.class})
    @Order(value=2000)
    public PropagatingSenderTracingObservationHandler<?> propagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingSenderTracingObservationHandler(tracer, propagator);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Propagator.class})
    @Order(value=1000)
    public PropagatingReceiverTracingObservationHandler<?> propagatingReceiverTracingObservationHandler(Tracer tracer, Propagator propagator) {
        return new PropagatingReceiverTracingObservationHandler(tracer, propagator);
    }

    private static final class SpelTagValueExpressionResolver
    implements ValueExpressionResolver {
        private SpelTagValueExpressionResolver() {
        }

        @Override
        public String resolve(String expression, Object parameter) {
            try {
                SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().build();
                SpelExpressionParser expressionParser = new SpelExpressionParser();
                Expression expressionToEvaluate = expressionParser.parseExpression(expression);
                return expressionToEvaluate.getValue(context, parameter, String.class);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to evaluate SpEL expression '%s'".formatted(expression), ex);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Advice.class})
    @ConditionalOnBooleanProperty(value={"management.observations.annotations.enabled"})
    static class SpanAspectConfiguration {
        SpanAspectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={NewSpanParser.class})
        DefaultNewSpanParser newSpanParser() {
            return new DefaultNewSpanParser();
        }

        @Bean
        @ConditionalOnMissingBean
        SpanTagAnnotationHandler spanTagAnnotationHandler(BeanFactory beanFactory) {
            SpelTagValueExpressionResolver valueExpressionResolver = new SpelTagValueExpressionResolver();
            return new SpanTagAnnotationHandler(beanFactory::getBean, ignored -> valueExpressionResolver);
        }

        @Bean
        @ConditionalOnMissingBean(value={MethodInvocationProcessor.class})
        ImperativeMethodInvocationProcessor imperativeMethodInvocationProcessor(NewSpanParser newSpanParser, Tracer tracer, SpanTagAnnotationHandler spanTagAnnotationHandler) {
            return new ImperativeMethodInvocationProcessor(newSpanParser, tracer, spanTagAnnotationHandler);
        }

        @Bean
        @ConditionalOnMissingBean
        SpanAspect spanAspect(MethodInvocationProcessor methodInvocationProcessor) {
            return new SpanAspect(methodInvocationProcessor);
        }
    }
}

