/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.opentelemetry;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OpenTelemetryResourceAttributes {
    private static final String DEFAULT_SERVICE_NAME = "unknown_service";
    private final Environment environment;
    private final Map<String, String> resourceAttributes;
    private final Function<String, String> getEnv;

    public OpenTelemetryResourceAttributes(Environment environment2, Map<String, String> resourceAttributes) {
        this(environment2, resourceAttributes, null);
    }

    OpenTelemetryResourceAttributes(Environment environment2, Map<String, String> resourceAttributes, Function<String, String> getEnv) {
        Assert.notNull((Object)environment2, "'environment' must not be null");
        this.environment = environment2;
        this.resourceAttributes = resourceAttributes != null ? resourceAttributes : Collections.emptyMap();
        this.getEnv = getEnv != null ? getEnv : System::getenv;
    }

    public void applyTo(BiConsumer<String, String> consumer) {
        Assert.notNull(consumer, "'consumer' must not be null");
        Map<String, String> attributes = this.getResourceAttributesFromEnv();
        this.resourceAttributes.forEach((name, value) -> {
            if (StringUtils.hasLength(name) && value != null) {
                attributes.put((String)name, (String)value);
            }
        });
        attributes.computeIfAbsent("service.name", key -> this.getApplicationName());
        attributes.computeIfAbsent("service.group", key -> this.getApplicationGroup());
        attributes.computeIfAbsent("service.namespace", key -> this.getServiceNamespace());
        attributes.forEach(consumer);
    }

    private String getApplicationName() {
        return this.environment.getProperty("spring.application.name", DEFAULT_SERVICE_NAME);
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    private String getApplicationGroup() {
        String applicationGroup = this.environment.getProperty("spring.application.group");
        return StringUtils.hasLength(applicationGroup) ? applicationGroup : null;
    }

    private String getServiceNamespace() {
        return this.environment.getProperty("spring.application.group");
    }

    private Map<String, String> getResourceAttributesFromEnv() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (String attribute : StringUtils.tokenizeToStringArray(this.getEnv("OTEL_RESOURCE_ATTRIBUTES"), ",")) {
            int index = attribute.indexOf(61);
            if (index <= 0) continue;
            String key = attribute.substring(0, index);
            String value = attribute.substring(index + 1);
            attributes.put(key.trim(), OpenTelemetryResourceAttributes.decode(value.trim()));
        }
        String otelServiceName = this.getEnv("OTEL_SERVICE_NAME");
        if (otelServiceName != null) {
            attributes.put("service.name", otelServiceName);
        }
        return attributes;
    }

    private String getEnv(String name) {
        return this.getEnv.apply(name);
    }

    private static String decode(String value) {
        if (value.indexOf(37) < 0) {
            return value;
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b = bytes[i2];
            if (b != 37) {
                bos.write(b);
                continue;
            }
            int u = OpenTelemetryResourceAttributes.decodeHex(bytes, i2 + 1);
            int l = OpenTelemetryResourceAttributes.decodeHex(bytes, i2 + 2);
            if (u < 0 || l < 0) {
                throw new IllegalArgumentException("Failed to decode percent-encoded characters at index %d in the value: '%s'".formatted(i2, value));
            }
            bos.write((u << 4) + l);
            i2 += 2;
        }
        return bos.toString(StandardCharsets.UTF_8);
    }

    private static int decodeHex(byte[] bytes, int index) {
        return index < bytes.length ? Character.digit(bytes[index], 16) : -1;
    }
}

