/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.metrics.AutoConfiguredCompositeMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.ApplicationContext;

class MeterRegistryPostProcessor
implements BeanPostProcessor,
SmartInitializingSingleton {
    private final CompositeMeterRegistries compositeMeterRegistries;
    private final ObjectProvider<MetricsProperties> properties;
    private final ObjectProvider<MeterRegistryCustomizer<?>> customizers;
    private final ObjectProvider<MeterFilter> filters;
    private final ObjectProvider<MeterBinder> binders;
    private volatile boolean deferBinding = true;
    private final Set<MeterRegistry> deferredBindings = new LinkedHashSet<MeterRegistry>();

    MeterRegistryPostProcessor(ApplicationContext applicationContext, ObjectProvider<MetricsProperties> metricsProperties, ObjectProvider<MeterRegistryCustomizer<?>> customizers, ObjectProvider<MeterFilter> filters, ObjectProvider<MeterBinder> binders) {
        this(CompositeMeterRegistries.of(applicationContext), metricsProperties, customizers, filters, binders);
    }

    MeterRegistryPostProcessor(CompositeMeterRegistries compositeMeterRegistries, ObjectProvider<MetricsProperties> properties, ObjectProvider<MeterRegistryCustomizer<?>> customizers, ObjectProvider<MeterFilter> filters, ObjectProvider<MeterBinder> binders) {
        this.compositeMeterRegistries = compositeMeterRegistries;
        this.properties = properties;
        this.customizers = customizers;
        this.filters = filters;
        this.binders = binders;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof MeterRegistry) {
            MeterRegistry meterRegistry = (MeterRegistry)bean2;
            this.postProcessMeterRegistry(meterRegistry);
        }
        return bean2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterSingletonsInstantiated() {
        Set<MeterRegistry> set = this.deferredBindings;
        synchronized (set) {
            this.deferBinding = false;
            this.deferredBindings.forEach(this::applyBinders);
        }
    }

    private void postProcessMeterRegistry(MeterRegistry meterRegistry) {
        this.applyCustomizers(meterRegistry);
        this.applyFilters(meterRegistry);
        this.addToGlobalRegistryIfNecessary(meterRegistry);
        if (this.isBindable(meterRegistry)) {
            this.applyBinders(meterRegistry);
        }
    }

    private void applyCustomizers(MeterRegistry meterRegistry) {
        List<MeterRegistryCustomizer<?>> customizers = this.customizers.orderedStream().toList();
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(MeterRegistryCustomizer.class, customizers, meterRegistry, new Object[0]).withLogger((Class)MeterRegistryPostProcessor.class)).invoke(customizer2 -> customizer2.customize(meterRegistry));
    }

    private void applyFilters(MeterRegistry meterRegistry) {
        if (meterRegistry instanceof AutoConfiguredCompositeMeterRegistry) {
            return;
        }
        this.filters.orderedStream().forEach(meterRegistry.config()::meterFilter);
    }

    private void addToGlobalRegistryIfNecessary(MeterRegistry meterRegistry) {
        if (this.properties.getObject().isUseGlobalRegistry() && !this.isGlobalRegistry(meterRegistry)) {
            Metrics.addRegistry(meterRegistry);
        }
    }

    private boolean isGlobalRegistry(MeterRegistry meterRegistry) {
        return meterRegistry == Metrics.globalRegistry;
    }

    private boolean isBindable(MeterRegistry meterRegistry) {
        return this.isAutoConfiguredComposite(meterRegistry) || this.isCompositeWithOnlyUserDefinedComposites(meterRegistry) || this.noCompositeMeterRegistries();
    }

    private boolean isAutoConfiguredComposite(MeterRegistry meterRegistry) {
        return meterRegistry instanceof AutoConfiguredCompositeMeterRegistry;
    }

    private boolean isCompositeWithOnlyUserDefinedComposites(MeterRegistry meterRegistry) {
        return this.compositeMeterRegistries == CompositeMeterRegistries.ONLY_USER_DEFINED && meterRegistry instanceof CompositeMeterRegistry;
    }

    private boolean noCompositeMeterRegistries() {
        return this.compositeMeterRegistries == CompositeMeterRegistries.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyBinders(MeterRegistry meterRegistry) {
        if (this.deferBinding) {
            Set<MeterRegistry> set = this.deferredBindings;
            synchronized (set) {
                if (this.deferBinding) {
                    this.deferredBindings.add(meterRegistry);
                    return;
                }
            }
        }
        this.binders.orderedStream().forEach(binder -> binder.bindTo(meterRegistry));
    }

    static enum CompositeMeterRegistries {
        NONE,
        AUTO_CONFIGURED,
        ONLY_USER_DEFINED;


        private static CompositeMeterRegistries of(ApplicationContext context) {
            if (CompositeMeterRegistries.hasBeansOfType(AutoConfiguredCompositeMeterRegistry.class, context)) {
                return AUTO_CONFIGURED;
            }
            return CompositeMeterRegistries.hasBeansOfType(CompositeMeterRegistry.class, context) ? ONLY_USER_DEFINED : NONE;
        }

        private static boolean hasBeansOfType(Class<?> type, ApplicationContext context) {
            return context.getBeanNamesForType(type, false, false).length > 0;
        }
    }
}

