/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import ch.qos.logback.classic.LoggerContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@AutoConfiguration(after={MetricsAutoConfiguration.class, CompositeMeterRegistryAutoConfiguration.class})
@ConditionalOnClass(value={MeterRegistry.class, LoggerContext.class, LoggerFactory.class})
@ConditionalOnBean(value={MeterRegistry.class})
@Conditional(value={LogbackLoggingCondition.class})
public class LogbackMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LogbackMetrics logbackMetrics() {
        return new LogbackMetrics();
    }

    static class LogbackLoggingCondition
    extends SpringBootCondition {
        LogbackLoggingCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            ConditionMessage.Builder message = ConditionMessage.forCondition("LogbackLoggingCondition", new Object[0]);
            if (loggerFactory instanceof LoggerContext) {
                return ConditionOutcome.match(message.because("ILoggerFactory is a Logback LoggerContext"));
            }
            return ConditionOutcome.noMatch(message.because("ILoggerFactory is an instance of " + loggerFactory.getClass().getCanonicalName()));
        }
    }
}

