/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.boot.actuate.autoconfigure.health.AutoConfiguredHealthEndpointGroup;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.health.HealthProperties;
import org.springframework.boot.actuate.autoconfigure.health.IncludeExcludeGroupMemberPredicate;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.Show;
import org.springframework.boot.actuate.endpoint.web.AdditionalPathsMapper;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.AdditionalHealthEndpointPath;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroup;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.actuate.health.StatusAggregator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class AutoConfiguredHealthEndpointGroups
implements HealthEndpointGroups,
AdditionalPathsMapper {
    private static final Predicate<String> ALL = name -> true;
    private final HealthEndpointGroup primaryGroup;
    private final Map<String, HealthEndpointGroup> groups;

    AutoConfiguredHealthEndpointGroups(ApplicationContext applicationContext, HealthEndpointProperties properties) {
        HttpCodeStatusMapper httpCodeStatusMapper;
        HierarchicalBeanFactory hierarchicalBeanFactory;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            hierarchicalBeanFactory = configurableContext.getBeanFactory();
        } else {
            hierarchicalBeanFactory = applicationContext;
        }
        ApplicationContext beanFactory = hierarchicalBeanFactory;
        Show showComponents = properties.getShowComponents();
        Show showDetails = properties.getShowDetails();
        Set<String> roles = properties.getRoles();
        StatusAggregator statusAggregator = this.getNonQualifiedBean(beanFactory, StatusAggregator.class);
        if (statusAggregator == null) {
            statusAggregator = new SimpleStatusAggregator(properties.getStatus().getOrder());
        }
        if ((httpCodeStatusMapper = this.getNonQualifiedBean(beanFactory, HttpCodeStatusMapper.class)) == null) {
            httpCodeStatusMapper = new SimpleHttpCodeStatusMapper(properties.getStatus().getHttpMapping());
        }
        this.primaryGroup = new AutoConfiguredHealthEndpointGroup(ALL, statusAggregator, httpCodeStatusMapper, showComponents, showDetails, roles, null);
        this.groups = this.createGroups(properties.getGroup(), beanFactory, statusAggregator, httpCodeStatusMapper, showComponents, showDetails, roles);
    }

    private Map<String, HealthEndpointGroup> createGroups(Map<String, HealthEndpointProperties.Group> groupProperties, BeanFactory beanFactory, StatusAggregator defaultStatusAggregator, HttpCodeStatusMapper defaultHttpCodeStatusMapper, Show defaultShowComponents, Show defaultShowDetails, Set<String> defaultRoles) {
        LinkedHashMap groups = new LinkedHashMap();
        groupProperties.forEach((groupName, group) -> {
            HealthProperties.Status status = group.getStatus();
            Show showComponents = group.getShowComponents() != null ? group.getShowComponents() : defaultShowComponents;
            Show showDetails = group.getShowDetails() != null ? group.getShowDetails() : defaultShowDetails;
            Set<String> roles = !CollectionUtils.isEmpty(group.getRoles()) ? group.getRoles() : defaultRoles;
            StatusAggregator statusAggregator = this.getQualifiedBean(beanFactory, (Class)StatusAggregator.class, (String)groupName, () -> {
                if (!CollectionUtils.isEmpty(status.getOrder())) {
                    return new SimpleStatusAggregator(status.getOrder());
                }
                return defaultStatusAggregator;
            });
            HttpCodeStatusMapper httpCodeStatusMapper = this.getQualifiedBean(beanFactory, (Class)HttpCodeStatusMapper.class, (String)groupName, () -> {
                if (!CollectionUtils.isEmpty(status.getHttpMapping())) {
                    return new SimpleHttpCodeStatusMapper(status.getHttpMapping());
                }
                return defaultHttpCodeStatusMapper;
            });
            IncludeExcludeGroupMemberPredicate members = new IncludeExcludeGroupMemberPredicate(group.getInclude(), group.getExclude());
            AdditionalHealthEndpointPath additionalPath = group.getAdditionalPath() != null ? AdditionalHealthEndpointPath.from(group.getAdditionalPath()) : null;
            groups.put(groupName, new AutoConfiguredHealthEndpointGroup(members, statusAggregator, httpCodeStatusMapper, showComponents, showDetails, roles, additionalPath));
        });
        return Collections.unmodifiableMap(groups);
    }

    private <T> T getNonQualifiedBean(ListableBeanFactory beanFactory, Class<T> type) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, type)) {
            String[] aliases = beanFactory.getAliases(beanName);
            if (BeanFactoryAnnotationUtils.isQualifierMatch(qualifier -> !qualifier.equals(beanName) && !ObjectUtils.containsElement(aliases, qualifier), beanName, beanFactory)) continue;
            candidates.add(beanName);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return beanFactory.getBean((String)candidates.get(0), type);
        }
        return beanFactory.getBean(type);
    }

    private <T> T getQualifiedBean(BeanFactory beanFactory, Class<T> type, String qualifier, Supplier<T> fallback) {
        try {
            return BeanFactoryAnnotationUtils.qualifiedBeanOfType(beanFactory, type, qualifier);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return fallback.get();
        }
    }

    @Override
    public HealthEndpointGroup getPrimary() {
        return this.primaryGroup;
    }

    @Override
    public Set<String> getNames() {
        return this.groups.keySet();
    }

    @Override
    public HealthEndpointGroup get(String name) {
        return this.groups.get(name);
    }

    @Override
    public List<String> getAdditionalPaths(EndpointId endpointId, WebServerNamespace webServerNamespace) {
        if (!HealthEndpoint.ID.equals(endpointId)) {
            return null;
        }
        return this.streamAllGroups().map(HealthEndpointGroup::getAdditionalPath).filter(Objects::nonNull).filter(additionalPath -> additionalPath.hasNamespace(webServerNamespace)).map(AdditionalHealthEndpointPath::getValue).toList();
    }

    private Stream<HealthEndpointGroup> streamAllGroups() {
        return Stream.concat(Stream.of(this.primaryGroup), this.groups.values().stream());
    }
}

