/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web.reactive;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.CorsEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.jackson.EndpointObjectMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.reactive.AdditionalHealthEndpointPathsWebFluxHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.reactive.ControllerEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.reactive.WebFluxEndpointHandlerMapping;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.core.codec.Encoder;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.reactive.DispatcherHandler;

@ManagementContextConfiguration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={DispatcherHandler.class, HttpHandler.class})
@ConditionalOnBean(value={WebEndpointsSupplier.class})
@EnableConfigurationProperties(value={CorsEndpointProperties.class})
public class WebFluxEndpointManagementContextConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebFluxEndpointHandlerMapping webEndpointReactiveHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, ControllerEndpointsSupplier controllerEndpointsSupplier, EndpointMediaTypes endpointMediaTypes, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, Environment environment2) {
        String basePath = webEndpointProperties.getBasePath();
        EndpointMapping endpointMapping = new EndpointMapping(basePath);
        Collection<ExposableWebEndpoint> endpoints = webEndpointsSupplier.getEndpoints();
        ArrayList<ExposableWebEndpoint> allEndpoints = new ArrayList<ExposableWebEndpoint>();
        allEndpoints.addAll(endpoints);
        allEndpoints.addAll(controllerEndpointsSupplier.getEndpoints());
        return new WebFluxEndpointHandlerMapping(endpointMapping, endpoints, endpointMediaTypes, corsProperties.toCorsConfiguration(), new EndpointLinksResolver(allEndpoints, basePath), this.shouldRegisterLinksMapping(webEndpointProperties, environment2, basePath));
    }

    private boolean shouldRegisterLinksMapping(WebEndpointProperties properties, Environment environment2, String basePath) {
        return properties.getDiscovery().isEnabled() && (StringUtils.hasText(basePath) || ManagementPortType.get(environment2) == ManagementPortType.DIFFERENT);
    }

    @Bean
    @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
    @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
    @ConditionalOnBean(value={HealthEndpoint.class})
    public AdditionalHealthEndpointPathsWebFluxHandlerMapping managementHealthEndpointWebFluxHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        ExposableWebEndpoint healthEndpoint = webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals(HealthEndpoint.ID)).findFirst().orElse(null);
        return new AdditionalHealthEndpointPathsWebFluxHandlerMapping(new EndpointMapping(""), healthEndpoint, groups.getAllWithAdditionalPath(WebServerNamespace.MANAGEMENT));
    }

    @Bean
    @ConditionalOnMissingBean
    @Deprecated(since="3.3.5", forRemoval=true)
    public ControllerEndpointHandlerMapping controllerEndpointHandlerMapping(ControllerEndpointsSupplier controllerEndpointsSupplier, CorsEndpointProperties corsProperties, WebEndpointProperties webEndpointProperties, EndpointAccessResolver endpointAccessResolver) {
        EndpointMapping endpointMapping = new EndpointMapping(webEndpointProperties.getBasePath());
        return new ControllerEndpointHandlerMapping(endpointMapping, controllerEndpointsSupplier.getEndpoints(), corsProperties.toCorsConfiguration(), endpointAccessResolver);
    }

    @Bean
    @ConditionalOnBean(value={EndpointObjectMapper.class})
    @Role(value=2)
    static ServerCodecConfigurerEndpointObjectMapperBeanPostProcessor serverCodecConfigurerEndpointObjectMapperBeanPostProcessor(ObjectProvider<EndpointObjectMapper> endpointObjectMapper) {
        return new ServerCodecConfigurerEndpointObjectMapperBeanPostProcessor(SingletonSupplier.of(endpointObjectMapper::getObject));
    }

    static class ServerCodecConfigurerEndpointObjectMapperBeanPostProcessor
    implements BeanPostProcessor {
        private static final List<MediaType> MEDIA_TYPES = Collections.unmodifiableList(Arrays.asList(MediaType.APPLICATION_JSON, new MediaType("application", "*+json")));
        private final Supplier<EndpointObjectMapper> endpointObjectMapper;

        ServerCodecConfigurerEndpointObjectMapperBeanPostProcessor(Supplier<EndpointObjectMapper> endpointObjectMapper) {
            this.endpointObjectMapper = endpointObjectMapper;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean2, String beanName) throws BeansException {
            if (bean2 instanceof ServerCodecConfigurer) {
                ServerCodecConfigurer serverCodecConfigurer = (ServerCodecConfigurer)bean2;
                this.process(serverCodecConfigurer);
            }
            return bean2;
        }

        private void process(ServerCodecConfigurer configurer) {
            for (HttpMessageWriter<?> writer : configurer.getWriters()) {
                if (!(writer instanceof EncoderHttpMessageWriter)) continue;
                EncoderHttpMessageWriter encoderHttpMessageWriter = (EncoderHttpMessageWriter)writer;
                this.process(encoderHttpMessageWriter.getEncoder());
            }
        }

        private void process(Encoder<?> encoder) {
            if (encoder instanceof Jackson2JsonEncoder) {
                Jackson2JsonEncoder jackson2JsonEncoder = (Jackson2JsonEncoder)encoder;
                jackson2JsonEncoder.registerObjectMappersForType(OperationResponseBody.class, associations -> {
                    ObjectMapper objectMapper = this.endpointObjectMapper.get().get();
                    MEDIA_TYPES.forEach(mimeType -> associations.put(mimeType, objectMapper));
                });
            }
        }
    }
}

