/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="management.endpoints.web")
public class WebEndpointProperties {
    private final Exposure exposure = new Exposure();
    private String basePath = "/actuator";
    private final Map<String, String> pathMapping = new LinkedHashMap<String, String>();
    private final Discovery discovery = new Discovery();

    public Exposure getExposure() {
        return this.exposure;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        Assert.isTrue(basePath.isEmpty() || basePath.startsWith("/"), "'basePath' must start with '/' or be empty");
        this.basePath = this.cleanBasePath(basePath);
    }

    private String cleanBasePath(String basePath) {
        if (StringUtils.hasText(basePath) && basePath.endsWith("/")) {
            return basePath.substring(0, basePath.length() - 1);
        }
        return basePath;
    }

    public Map<String, String> getPathMapping() {
        return this.pathMapping;
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public static class Exposure {
        private Set<String> include = new LinkedHashSet<String>();
        private Set<String> exclude = new LinkedHashSet<String>();

        public Set<String> getInclude() {
            return this.include;
        }

        public void setInclude(Set<String> include) {
            this.include = include;
        }

        public Set<String> getExclude() {
            return this.exclude;
        }

        public void setExclude(Set<String> exclude) {
            this.exclude = exclude;
        }
    }

    public static class Discovery {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

