/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.core.utils.SpringDocUtils;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class SwaggerWelcomeWebMvc
extends SwaggerWelcomeCommon {
    private final SpringWebProvider springWebProvider;
    @Value(value="${spring.mvc.servlet.path:#{null}}")
    private String mvcServletPath;

    public SwaggerWelcomeWebMvc(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SpringWebProvider springWebProvider) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.springWebProvider = springWebProvider;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.swagger-ui.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_SWAGGER_UI_PATH}}"})
    public ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        return super.redirectToUi(request);
    }

    @Override
    protected void calculateUiRootPath(SwaggerUiConfigParameters swaggerUiConfigParameters, StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        if (SpringDocUtils.isValidPath(this.mvcServletPath)) {
            sbUrl.append(this.mvcServletPath);
        }
        this.calculateUiRootCommon(swaggerUiConfigParameters, sbUrl, sbUrls);
    }

    @Override
    protected String buildUrl(String contextPath, String docsUrl) {
        if (SpringDocUtils.isValidPath(this.mvcServletPath)) {
            contextPath = (String)contextPath + this.mvcServletPath;
        }
        return super.buildUrl((String)contextPath, docsUrl);
    }

    @Override
    protected void buildApiDocUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setApiDocsUrl(this.buildUrlWithContextPath(swaggerUiConfigParameters, this.springDocConfigProperties.getApiDocs().getPath()));
    }

    @Override
    protected String buildUrlWithContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, String swaggerUiUrl) {
        if (swaggerUiConfigParameters.getPathPrefix() == null) {
            swaggerUiConfigParameters.setPathPrefix(this.springWebProvider.findPathPrefix(this.springDocConfigProperties));
        }
        return this.buildUrl(swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getPathPrefix(), swaggerUiUrl);
    }

    @Override
    protected void buildSwaggerConfigUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setConfigUrl(swaggerUiConfigParameters.getApiDocsUrl() + "/swagger-config");
    }
}

