/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerEndpoint(id="swagger-ui")
public class SwaggerWelcomeActuator
extends SwaggerWelcomeCommon {
    private static final String SWAGGER_CONFIG_ACTUATOR_URL = "/swagger-config";
    private final WebEndpointProperties webEndpointProperties;

    public SwaggerWelcomeActuator(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, WebEndpointProperties webEndpointProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
        this.webEndpointProperties = webEndpointProperties;
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/"})
    public ResponseEntity<Void> redirectToUi(HttpServletRequest request) {
        return super.redirectToUi(request);
    }

    @Override
    @Operation(hidden=true)
    @GetMapping(value={"/swagger-config"}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> openapiJson(HttpServletRequest request) {
        return super.openapiJson(request);
    }

    @Override
    protected void calculateUiRootPath(SwaggerUiConfigParameters swaggerUiConfigParameters, StringBuilder ... sbUrls) {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(this.webEndpointProperties.getBasePath());
        this.calculateUiRootCommon(swaggerUiConfigParameters, sbUrl, sbUrls);
    }

    @Override
    protected void buildApiDocUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setApiDocsUrl(this.buildUrl(swaggerUiConfigParameters.getContextPath() + this.webEndpointProperties.getBasePath(), "openapi"));
    }

    @Override
    protected String buildUrlWithContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, String swaggerUiUrl) {
        return this.buildUrl(swaggerUiConfigParameters.getContextPath() + this.webEndpointProperties.getBasePath(), swaggerUiUrl);
    }

    @Override
    protected void buildSwaggerConfigUrl(SwaggerUiConfigParameters swaggerUiConfigParameters) {
        swaggerUiConfigParameters.setConfigUrl(swaggerUiConfigParameters.getContextPath() + this.webEndpointProperties.getBasePath() + "/swagger-ui/swagger-config");
    }
}

