/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import java.util.List;
import java.util.Optional;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springdoc.webmvc.ui.SwaggerResourceResolver;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class SwaggerWebMvcConfigurer
implements WebMvcConfigurer {
    private final SwaggerIndexTransformer swaggerIndexTransformer;
    private final Optional<ActuatorProvider> actuatorProvider;
    private final SwaggerUiConfigProperties swaggerUiConfigProperties;
    private final SwaggerResourceResolver swaggerResourceResolver;

    public SwaggerWebMvcConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, SwaggerIndexTransformer swaggerIndexTransformer, Optional<ActuatorProvider> actuatorProvider, SwaggerResourceResolver swaggerResourceResolver) {
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.actuatorProvider = actuatorProvider;
        this.swaggerResourceResolver = swaggerResourceResolver;
        this.swaggerUiConfigProperties = swaggerUiConfigProperties;
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        String swaggerPath = this.swaggerUiConfigProperties.getPath();
        if (swaggerPath.contains("/")) {
            uiRootPath.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        if (this.actuatorProvider.isPresent() && this.actuatorProvider.get().isUseManagementPort()) {
            uiRootPath.append(this.actuatorProvider.get().getBasePath());
        }
        registry.addResourceHandler(String.valueOf(uiRootPath) + "/swagger-ui*/*swagger-initializer.js").addResourceLocations("classpath:/META-INF/resources/webjars/").setCachePeriod(0).resourceChain(false).addResolver(this.swaggerResourceResolver).addTransformer(this.swaggerIndexTransformer);
        registry.addResourceHandler(String.valueOf(uiRootPath) + "/swagger-ui*/**").addResourceLocations("classpath:/META-INF/resources/webjars/").resourceChain(false).addResolver(this.swaggerResourceResolver).addTransformer(this.swaggerIndexTransformer);
    }

    @Override
    public void configurePathMatch(PathMatchConfigurer configurer) {
    }

    @Override
    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    @Override
    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    @Override
    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    @Override
    public void addFormatters(FormatterRegistry registry) {
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
    }

    @Override
    public void addViewControllers(ViewControllerRegistry registry) {
    }

    @Override
    public void configureViewResolvers(ViewResolverRegistry registry) {
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    @Override
    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    @Override
    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    @Override
    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    @Override
    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    @Override
    @Nullable
    public Validator getValidator() {
        return null;
    }

    @Override
    @Nullable
    public MessageCodesResolver getMessageCodesResolver() {
        return null;
    }
}

