/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.converter.ModelConverterContextImpl;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.SchemaProperty;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestAttribute;

public class SpringDocAnnotationsUtils
extends AnnotationsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDocAnnotationsUtils.class);
    private static final List<Class> ANNOTATIONS_TO_IGNORE = Collections.synchronizedList(new ArrayList());
    private static final ThreadLocal<Map<Boolean, ModelConverterContext>> MODEL_CONVERTER_CONTEXT_MAP = ThreadLocal.withInitial(HashMap::new);

    public static Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components, JsonView jsonView, Annotation[] annotations, SpecVersion specVersion) {
        Schema schemaObject = SpringDocAnnotationsUtils.extractSchema(components, schemaImplementation, jsonView, annotations, specVersion);
        if (schemaObject != null && StringUtils.isBlank(schemaObject.get$ref()) && StringUtils.isBlank(schemaObject.getType()) && !(schemaObject instanceof ComposedSchema)) {
            schemaObject.setType("string");
        }
        return schemaObject;
    }

    public static Schema extractSchema(Components components, Type returnType, JsonView jsonView, Annotation[] annotations, SpecVersion specVersion) {
        AnnotatedType annotatedType;
        ResolvedSchema resolvedSchema;
        boolean openapi31;
        if (returnType == null) {
            return null;
        }
        Schema schemaN = null;
        boolean bl = openapi31 = SpecVersion.V31 == specVersion;
        if (jsonView != null) {
            annotations = ArrayUtils.addAll(annotations, jsonView);
        }
        if ((resolvedSchema = SpringDocAnnotationsUtils.resolveAsResolvedSchema(openapi31, annotatedType = new AnnotatedType(returnType).resolveAsRef(true).jsonViewAnnotation(jsonView).ctxAnnotations(annotations))) != null) {
            Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
            if (!CollectionUtils.isEmpty(schemaMap) && components != null) {
                Map<String, Schema> componentSchemas = components.getSchemas();
                if (componentSchemas == null) {
                    componentSchemas = new LinkedHashMap<String, Schema>();
                    componentSchemas.putAll(schemaMap);
                } else {
                    for (Map.Entry<String, Schema> entry : schemaMap.entrySet()) {
                        Schema existingSchema = componentSchemas.get(entry.getKey());
                        if (!componentSchemas.containsKey(entry.getKey()) || !entry.getValue().getClass().equals(existingSchema.getClass()) && entry.getValue().getAllOf() != null) {
                            componentSchemas.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (!componentSchemas.containsKey(entry.getKey()) || !schemaMap.containsKey(entry.getKey())) continue;
                        LinkedHashSet<Schema> existingAllOf = new LinkedHashSet<Schema>();
                        if (existingSchema.getAllOf() != null) {
                            existingAllOf.addAll(existingSchema.getAllOf());
                        }
                        if (schemaMap.get(entry.getKey()).getAllOf() == null) continue;
                        existingAllOf.addAll(schemaMap.get(entry.getKey()).getAllOf());
                        existingSchema.setAllOf(new ArrayList<Schema>(existingAllOf));
                    }
                }
                components.setSchemas(componentSchemas);
            }
            if (resolvedSchema.schema != null) {
                schemaN = new Schema(specVersion);
                if (StringUtils.isNotBlank(resolvedSchema.schema.getName())) {
                    schemaN.set$ref("#/components/schemas/" + resolvedSchema.schema.getName());
                } else {
                    schemaN = resolvedSchema.schema;
                }
            }
        }
        if (openapi31) {
            SpringDocUtils.handleSchemaTypes(schemaN);
        }
        return schemaN;
    }

    public static Optional<Content> getContent(io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Schema schema, Components components, JsonView jsonViewAnnotation, boolean openapi31) {
        if (ArrayUtils.isEmpty(annotationContents)) {
            return Optional.empty();
        }
        Content content = new Content();
        for (io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            MediaType mediaType = SpringDocAnnotationsUtils.getMediaType(schema, components, jsonViewAnnotation, annotationContent, openapi31);
            ExampleObject[] examples = annotationContent.examples();
            SpringDocAnnotationsUtils.setExamples(mediaType, examples);
            SpringDocAnnotationsUtils.addExtension(annotationContent, mediaType, openapi31);
            Encoding[] encodings = annotationContent.encoding();
            SpringDocAnnotationsUtils.addEncodingToMediaType(jsonViewAnnotation, mediaType, encodings, openapi31);
            if (StringUtils.isNotBlank(annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            if (mediaType.getSchema() == null && mediaType.getEncoding() == null && mediaType.getExample() == null && mediaType.getExamples() == null && mediaType.getExtensions() == null) continue;
            SpringDocAnnotationsUtils.applyTypes(classTypes, methodTypes, content, mediaType);
        }
        if (content.isEmpty() && annotationContents.length != 1) {
            return Optional.empty();
        }
        SpringDocUtils.handleSchemaTypes(content);
        return Optional.of(content);
    }

    public static void mergeSchema(Content existingContent, Schema<?> schemaN, String mediaTypeStr) {
        if (existingContent.containsKey(mediaTypeStr)) {
            MediaType mediaType = (MediaType)existingContent.get(mediaTypeStr);
            if (!schemaN.equals(mediaType.getSchema())) {
                Schema firstSchema = mediaType.getSchema();
                Schema schemaObject = null;
                if (firstSchema == null) {
                    schemaObject = schemaN;
                } else if (firstSchema instanceof ComposedSchema) {
                    schemaObject = firstSchema;
                    List<Schema> listOneOf = schemaObject.getOneOf();
                    if (!CollectionUtils.isEmpty(listOneOf) && !listOneOf.contains(schemaN)) {
                        schemaObject.addOneOfItem(schemaN);
                    }
                } else {
                    schemaObject = new ComposedSchema();
                    schemaObject.addOneOfItem(schemaN);
                    schemaObject.addOneOfItem(firstSchema);
                }
                mediaType.setSchema(schemaObject);
                existingContent.addMediaType(mediaTypeStr, mediaType);
            }
        } else {
            existingContent.addMediaType(mediaTypeStr, new MediaType().schema(schemaN));
        }
    }

    public static boolean isAnnotationToIgnore(MethodParameter parameter) {
        boolean annotationFirstCheck = ANNOTATIONS_TO_IGNORE.stream().anyMatch(annotation -> parameter.getParameterIndex() != -1 && AnnotationUtils.findAnnotation(parameter.getMethod().getParameters()[parameter.getParameterIndex()], annotation) != null || AnnotationUtils.findAnnotation(parameter.getParameterType(), annotation) != null);
        boolean annotationSecondCheck = Arrays.stream(parameter.getParameterAnnotations()).anyMatch(annotation -> ANNOTATIONS_TO_IGNORE.contains(annotation.annotationType()) || ANNOTATIONS_TO_IGNORE.stream().anyMatch(annotationToIgnore -> annotation.annotationType().getDeclaredAnnotation(annotationToIgnore) != null));
        return annotationFirstCheck || annotationSecondCheck;
    }

    public static boolean isAnnotationToIgnore(Type type) {
        return ANNOTATIONS_TO_IGNORE.stream().anyMatch(annotation -> type instanceof Class && AnnotationUtils.findAnnotation((Class)type, annotation) != null);
    }

    public static void addAnnotationsToIgnore(Class<?> ... classes) {
        ANNOTATIONS_TO_IGNORE.addAll(Arrays.asList(classes));
    }

    public static void removeAnnotationsToIgnore(Class<?> ... classes) {
        List<Class<?>> classesToIgnore = Arrays.asList(classes);
        if (ANNOTATIONS_TO_IGNORE.containsAll(classesToIgnore)) {
            ANNOTATIONS_TO_IGNORE.removeAll(Arrays.asList(classes));
        }
    }

    private static void addEncodingToMediaType(JsonView jsonViewAnnotation, MediaType mediaType, Encoding[] encodings, boolean openapi31) {
        for (Encoding encoding : encodings) {
            SpringDocAnnotationsUtils.addEncodingToMediaType(mediaType, encoding, jsonViewAnnotation, openapi31);
        }
    }

    private static void addExtension(io.swagger.v3.oas.annotations.media.Content annotationContent, MediaType mediaType, boolean openapi31) {
        if (annotationContent.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(openapi31, annotationContent.extensions());
            extensions.forEach(mediaType::addExtension);
        }
    }

    private static void setExamples(MediaType mediaType, ExampleObject[] examples) {
        if (examples.length == 1 && StringUtils.isBlank(examples[0].name())) {
            SpringDocAnnotationsUtils.getExample(examples[0], true).ifPresent(exampleObject -> mediaType.example(exampleObject.getValue()));
        } else {
            for (ExampleObject example : examples) {
                SpringDocAnnotationsUtils.getExample(example).ifPresent(exampleObject -> {
                    if (exampleObject.get$ref() != null) {
                        exampleObject.setDescription(null);
                    }
                    mediaType.addExamples(example.name(), (Example)exampleObject);
                });
            }
        }
    }

    private static MediaType getMediaType(Schema schema, Components components, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.media.Content annotationContent, boolean openapi31) {
        MediaType mediaType = new MediaType();
        if (annotationContent.schema().hidden()) {
            return mediaType;
        }
        if (components == null) {
            mediaType.setSchema(schema);
            return mediaType;
        }
        try {
            SpringDocAnnotationsUtils.getSchema(annotationContent, components, jsonViewAnnotation, openapi31).ifPresent(mediaType::setSchema);
            if (annotationContent.schemaProperties().length > 0) {
                if (mediaType.getSchema() == null) {
                    mediaType.schema(new ObjectSchema());
                }
                Schema oSchema = mediaType.getSchema();
                for (SchemaProperty sp : annotationContent.schemaProperties()) {
                    Class<?> schemaImplementation = sp.schema().implementation();
                    boolean isArray = false;
                    if (schemaImplementation == Void.class && (schemaImplementation = sp.array().schema().implementation()) != Void.class) {
                        isArray = true;
                    }
                    SpringDocAnnotationsUtils.getSchema(sp.schema(), sp.array(), isArray, schemaImplementation, components, jsonViewAnnotation, openapi31).ifPresent(s -> {
                        if ("array".equals(oSchema.getType())) {
                            oSchema.getItems().addProperty(sp.name(), (Schema)s);
                        } else {
                            oSchema.addProperty(sp.name(), (Schema)s);
                        }
                    });
                }
            }
            if (SpringDocAnnotationsUtils.hasSchemaAnnotation(annotationContent.additionalPropertiesSchema()) && mediaType.getSchema() != null && !Boolean.TRUE.equals(mediaType.getSchema().getAdditionalProperties()) && !Boolean.FALSE.equals(mediaType.getSchema().getAdditionalProperties())) {
                SpringDocAnnotationsUtils.getSchemaFromAnnotation(annotationContent.additionalPropertiesSchema(), components, jsonViewAnnotation, openapi31).ifPresent(s -> {
                    if ("array".equals(mediaType.getSchema().getType())) {
                        mediaType.getSchema().getItems().additionalProperties(s);
                    } else {
                        mediaType.getSchema().additionalProperties(s);
                    }
                });
            }
        }
        catch (Exception e) {
            if (SpringDocAnnotationsUtils.isArray(annotationContent)) {
                mediaType.setSchema(new ArraySchema().items((Schema)new StringSchema()));
            }
            mediaType.setSchema(new StringSchema());
        }
        return mediaType;
    }

    private static boolean isArray(io.swagger.v3.oas.annotations.media.Content annotationContent) {
        Class<?> schemaImplementation = annotationContent.schema().implementation();
        boolean isArray = false;
        if (schemaImplementation == Void.class && (schemaImplementation = annotationContent.array().schema().implementation()) != Void.class) {
            isArray = true;
        }
        return isArray;
    }

    public static Object resolveDefaultValue(String defaultValueStr, ObjectMapper objectMapper) {
        Object defaultValue = null;
        if (StringUtils.isNotEmpty(defaultValueStr)) {
            try {
                defaultValue = objectMapper.readTree(defaultValueStr);
            }
            catch (IOException e) {
                defaultValue = defaultValueStr;
            }
        }
        return defaultValue;
    }

    public static Optional<Map<String, Header>> getHeaders(io.swagger.v3.oas.annotations.headers.Header[] annotationHeaders, Components components, JsonView jsonViewAnnotation, boolean openapi31) {
        Optional<Map<String, Header>> headerMap = AnnotationsUtils.getHeaders(annotationHeaders, components, jsonViewAnnotation, openapi31);
        if (openapi31) {
            headerMap.ifPresent(map -> {
                for (Map.Entry entry : map.entrySet()) {
                    Header header = (Header)entry.getValue();
                    Schema schema = header.getSchema();
                    SpringDocUtils.handleSchemaTypes(schema);
                }
            });
        }
        return headerMap;
    }

    public static void clearCache(JavadocProvider javadocProvider) {
        if (javadocProvider != null) {
            javadocProvider.clearCache();
        }
        MODEL_CONVERTER_CONTEXT_MAP.remove();
    }

    private static ResolvedSchema resolveAsResolvedSchema(boolean openapi31, AnnotatedType type) {
        try {
            ModelConverterContext modelConverterContext = SpringDocAnnotationsUtils.getModelConverterContext(openapi31);
            ResolvedSchema resolvedSchema = new ResolvedSchema();
            resolvedSchema.schema = modelConverterContext.resolve(type);
            resolvedSchema.referencedSchemas = modelConverterContext.getDefinedModels();
            return resolvedSchema;
        }
        catch (Exception e) {
            LOGGER.warn("Graceful exception occurred", e);
            return null;
        }
    }

    private static ModelConverterContext getModelConverterContext(boolean openapi31) {
        Map<Boolean, ModelConverterContext> perThread = MODEL_CONVERTER_CONTEXT_MAP.get();
        return perThread.computeIfAbsent(openapi31, key -> new ModelConverterContextImpl(ModelConverters.getInstance(openapi31).getConverters()));
    }

    static {
        ANNOTATIONS_TO_IGNORE.add(Hidden.class);
        ANNOTATIONS_TO_IGNORE.add(JsonIgnore.class);
        ANNOTATIONS_TO_IGNORE.add(RequestAttribute.class);
    }
}

