/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.service.SecuritySchemePair;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.method.HandlerMethod;

public class SecurityService {
    private final PropertyResolverUtils propertyResolverUtils;

    public SecurityService(PropertyResolverUtils propertyResolverUtils) {
        this.propertyResolverUtils = propertyResolverUtils;
    }

    private static boolean isEmpty(OAuthFlows oAuthFlows) {
        boolean result = oAuthFlows == null ? true : (!SecurityService.isEmpty(oAuthFlows.implicit()) || !SecurityService.isEmpty(oAuthFlows.authorizationCode()) || !SecurityService.isEmpty(oAuthFlows.clientCredentials()) || !SecurityService.isEmpty(oAuthFlows.password()) ? false : oAuthFlows.extensions().length <= 0);
        return result;
    }

    private static boolean isEmpty(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow) {
        boolean result = oAuthFlow == null ? true : (!StringUtils.isBlank(oAuthFlow.authorizationUrl()) || !StringUtils.isBlank(oAuthFlow.refreshUrl()) || !StringUtils.isBlank(oAuthFlow.tokenUrl()) || !SecurityService.isEmpty(oAuthFlow.scopes()) ? false : oAuthFlow.extensions().length <= 0);
        return result;
    }

    private static boolean isEmpty(OAuthScope[] scopes) {
        return scopes == null || scopes.length == 0;
    }

    public io.swagger.v3.oas.annotations.security.SecurityRequirement[] getSecurityRequirements(HandlerMethod handlerMethod) {
        Class<?> beanType = handlerMethod.getBeanType();
        Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags = this.getSecurityRequirementsForClass(beanType);
        Method method = handlerMethod.getMethod();
        allSecurityTags = this.getSecurityRequirementsForMethod(method, allSecurityTags);
        return allSecurityTags != null ? allSecurityTags.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[0]) : null;
    }

    public Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> getSecurityRequirementsForMethod(Method method, Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags) {
        Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> securityRequirementsMethodList;
        SecurityRequirements methodSecurity = AnnotatedElementUtils.findMergedAnnotation(method, SecurityRequirements.class);
        if (methodSecurity != null) {
            allSecurityTags = this.addSecurityRequirements(allSecurityTags, new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>(Arrays.asList(methodSecurity.value())));
        }
        if (CollectionUtils.isEmpty(allSecurityTags) && !CollectionUtils.isEmpty(securityRequirementsMethodList = AnnotatedElementUtils.findMergedRepeatableAnnotations(method, io.swagger.v3.oas.annotations.security.SecurityRequirement.class))) {
            allSecurityTags = this.addSecurityRequirements(allSecurityTags, securityRequirementsMethodList);
        }
        return allSecurityTags;
    }

    public Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> getSecurityRequirementsForClass(Class<?> beanType) {
        Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> securityRequirementsClassList;
        Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags = null;
        SecurityRequirements classSecurity = AnnotatedElementUtils.findMergedAnnotation(beanType, SecurityRequirements.class);
        if (classSecurity != null) {
            allSecurityTags = new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>(Arrays.asList(classSecurity.value()));
        }
        if (CollectionUtils.isEmpty(allSecurityTags) && !CollectionUtils.isEmpty(securityRequirementsClassList = AnnotatedElementUtils.findMergedRepeatableAnnotations(beanType, io.swagger.v3.oas.annotations.security.SecurityRequirement.class))) {
            allSecurityTags = this.addSecurityRequirements(allSecurityTags, securityRequirementsClassList);
        }
        return allSecurityTags;
    }

    private Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> addSecurityRequirements(Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> allSecurityTags, Set<io.swagger.v3.oas.annotations.security.SecurityRequirement> securityRequirementsClassList) {
        if (allSecurityTags == null) {
            allSecurityTags = new HashSet<io.swagger.v3.oas.annotations.security.SecurityRequirement>();
        }
        allSecurityTags.addAll(securityRequirementsClassList);
        return allSecurityTags;
    }

    public Optional<List<SecurityRequirement>> getSecurityRequirements(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirementsApi) {
        if (securityRequirementsApi == null || securityRequirementsApi.length == 0) {
            return Optional.empty();
        }
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (io.swagger.v3.oas.annotations.security.SecurityRequirement securityRequirementApi : securityRequirementsApi) {
            if (StringUtils.isBlank(securityRequirementApi.name())) continue;
            SecurityRequirement securityRequirement = new SecurityRequirement();
            if (securityRequirementApi.scopes().length > 0) {
                securityRequirement.addList(securityRequirementApi.name(), Arrays.asList(securityRequirementApi.scopes()));
            } else {
                securityRequirement.addList(securityRequirementApi.name());
            }
            securityRequirements.add(securityRequirement);
        }
        if (securityRequirements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityRequirements);
    }

    Optional<SecuritySchemePair> getSecurityScheme(io.swagger.v3.oas.annotations.security.SecurityScheme securityScheme, Locale locale) {
        if (securityScheme == null) {
            return Optional.empty();
        }
        String key = null;
        SecurityScheme securitySchemeObject = new SecurityScheme();
        if (StringUtils.isNotBlank(securityScheme.in().toString())) {
            securitySchemeObject.setIn(this.getIn(securityScheme.in().toString()));
        }
        if (StringUtils.isNotBlank(securityScheme.type().toString())) {
            securitySchemeObject.setType(this.getType(securityScheme.type().toString()));
        }
        if (StringUtils.isNotBlank(securityScheme.openIdConnectUrl())) {
            securitySchemeObject.setOpenIdConnectUrl(this.propertyResolverUtils.resolve(securityScheme.openIdConnectUrl(), locale));
        }
        if (StringUtils.isNotBlank(securityScheme.scheme())) {
            securitySchemeObject.setScheme(securityScheme.scheme());
        }
        if (StringUtils.isNotBlank(securityScheme.bearerFormat())) {
            securitySchemeObject.setBearerFormat(securityScheme.bearerFormat());
        }
        if (StringUtils.isNotBlank(securityScheme.description())) {
            securitySchemeObject.setDescription(securityScheme.description());
        }
        if (StringUtils.isNotBlank(securityScheme.ref())) {
            securitySchemeObject.set$ref(securityScheme.ref());
        }
        if (StringUtils.isNotBlank(securityScheme.name())) {
            key = securityScheme.name();
            if (SecuritySchemeType.APIKEY.toString().equals(securitySchemeObject.getType().toString())) {
                securitySchemeObject.setName(securityScheme.name());
            }
        }
        if (StringUtils.isNotBlank(securityScheme.paramName())) {
            securitySchemeObject.setName(securityScheme.paramName());
        }
        if (securityScheme.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.propertyResolverUtils.isOpenapi31(), securityScheme.extensions());
            if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
                extensionsResolved.forEach(securitySchemeObject::addExtension);
            } else {
                extensions.forEach(securitySchemeObject::addExtension);
            }
        }
        this.getOAuthFlows(securityScheme.flows(), locale).ifPresent(securitySchemeObject::setFlows);
        SecuritySchemePair result = new SecuritySchemePair(key, securitySchemeObject);
        return Optional.of(result);
    }

    public void buildSecurityRequirement(io.swagger.v3.oas.annotations.security.SecurityRequirement[] securityRequirements, Operation operation) {
        Optional<List<SecurityRequirement>> requirementsObject = this.getSecurityRequirements(securityRequirements);
        requirementsObject.ifPresent(requirements -> requirements.stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(operation::addSecurityItem));
    }

    private Optional<io.swagger.v3.oas.models.security.OAuthFlows> getOAuthFlows(OAuthFlows oAuthFlows, Locale locale) {
        if (SecurityService.isEmpty(oAuthFlows)) {
            return Optional.empty();
        }
        io.swagger.v3.oas.models.security.OAuthFlows oAuthFlowsObject = new io.swagger.v3.oas.models.security.OAuthFlows();
        if (oAuthFlows.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.propertyResolverUtils.isOpenapi31(), oAuthFlows.extensions());
            if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
                extensionsResolved.forEach(oAuthFlowsObject::addExtension);
            } else {
                extensions.forEach(oAuthFlowsObject::addExtension);
            }
        }
        this.getOAuthFlow(oAuthFlows.authorizationCode(), locale).ifPresent(oAuthFlowsObject::setAuthorizationCode);
        this.getOAuthFlow(oAuthFlows.clientCredentials(), locale).ifPresent(oAuthFlowsObject::setClientCredentials);
        this.getOAuthFlow(oAuthFlows.implicit(), locale).ifPresent(oAuthFlowsObject::setImplicit);
        this.getOAuthFlow(oAuthFlows.password(), locale).ifPresent(oAuthFlowsObject::setPassword);
        return Optional.of(oAuthFlowsObject);
    }

    private Optional<OAuthFlow> getOAuthFlow(io.swagger.v3.oas.annotations.security.OAuthFlow oAuthFlow, Locale locale) {
        if (SecurityService.isEmpty(oAuthFlow)) {
            return Optional.empty();
        }
        OAuthFlow oAuthFlowObject = new OAuthFlow();
        if (StringUtils.isNotBlank(oAuthFlow.authorizationUrl())) {
            oAuthFlowObject.setAuthorizationUrl(this.propertyResolverUtils.resolve(oAuthFlow.authorizationUrl(), locale));
        }
        if (StringUtils.isNotBlank(oAuthFlow.refreshUrl())) {
            oAuthFlowObject.setRefreshUrl(this.propertyResolverUtils.resolve(oAuthFlow.refreshUrl(), locale));
        }
        if (StringUtils.isNotBlank(oAuthFlow.tokenUrl())) {
            oAuthFlowObject.setTokenUrl(this.propertyResolverUtils.resolve(oAuthFlow.tokenUrl(), locale));
        }
        if (oAuthFlow.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.propertyResolverUtils.isOpenapi31(), oAuthFlow.extensions());
            if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
                extensionsResolved.forEach(oAuthFlowObject::addExtension);
            } else {
                extensions.forEach(oAuthFlowObject::addExtension);
            }
        }
        this.getScopes(oAuthFlow.scopes()).ifPresent(oAuthFlowObject::setScopes);
        return Optional.of(oAuthFlowObject);
    }

    private Optional<Scopes> getScopes(OAuthScope[] scopes) {
        Scopes scopesObject = new Scopes();
        Arrays.stream(scopes).forEach(scope -> scopesObject.addString(scope.name(), scope.description()));
        return Optional.of(scopesObject);
    }

    private SecurityScheme.In getIn(String value) {
        return Arrays.stream(SecurityScheme.In.values()).filter(i2 -> i2.toString().equals(value)).findFirst().orElse(null);
    }

    private SecurityScheme.Type getType(String value) {
        return Arrays.stream(SecurityScheme.Type.values()).filter(i2 -> i2.toString().equals(value)).findFirst().orElse(null);
    }
}

