/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.models.ParameterInfo;
import org.springdoc.core.models.RequestBodyInfo;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.core.MethodParameter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestPart;

public class RequestBodyService {
    private final GenericParameterService parameterBuilder;
    private final PropertyResolverUtils propertyResolverUtils;

    public RequestBodyService(GenericParameterService parameterBuilder, PropertyResolverUtils propertyResolverUtils) {
        this.parameterBuilder = parameterBuilder;
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, RequestBody requestBodyOp, MethodAttributes methodAttributes, Components components, JsonView jsonViewAnnotation, Locale locale) {
        String[] classConsumes = methodAttributes.getClassConsumes();
        String[] methodConsumes = methodAttributes.getMethodConsumes();
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank(requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank(requestBody.description())) {
            requestBodyObject.setDescription(this.propertyResolverUtils.resolve(requestBody.description(), locale));
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(true);
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.parameterBuilder.isOpenapi31(), requestBody.extensions());
            extensions.forEach(requestBodyObject::addExtension);
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        this.buildRequestBodyContent(requestBody, requestBodyOp, methodAttributes, components, jsonViewAnnotation, classConsumes, methodConsumes, requestBodyObject);
        return Optional.of(requestBodyObject);
    }

    private void buildRequestBodyContent(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, RequestBody requestBodyOp, MethodAttributes methodAttributes, Components components, JsonView jsonViewAnnotation, String[] classConsumes, String[] methodConsumes, RequestBody requestBodyObject) {
        Optional<Content> optionalContent = SpringDocAnnotationsUtils.getContent(requestBody.content(), this.getConsumes(classConsumes), this.getConsumes(methodConsumes), null, components, jsonViewAnnotation, this.parameterBuilder.isOpenapi31());
        if (requestBodyOp == null) {
            if (optionalContent.isPresent()) {
                Content content = optionalContent.get();
                requestBodyObject.setContent(content);
                if (this.containsResponseBodySchema(content)) {
                    methodAttributes.setWithResponseBodySchemaDoc(true);
                }
            }
        } else {
            Content existingContent = requestBodyOp.getContent();
            if (optionalContent.isPresent() && existingContent != null) {
                Content newContent = optionalContent.get();
                if (methodAttributes.isMethodOverloaded()) {
                    Arrays.stream(methodAttributes.getMethodProduces()).filter(mediaTypeStr -> newContent.get(mediaTypeStr) != null).forEach(mediaTypeStr -> {
                        if (((MediaType)newContent.get(mediaTypeStr)).getSchema() != null) {
                            SpringDocAnnotationsUtils.mergeSchema(existingContent, ((MediaType)newContent.get(mediaTypeStr)).getSchema(), mediaTypeStr);
                        }
                    });
                    requestBodyObject.content(existingContent);
                } else {
                    requestBodyObject.content(newContent);
                }
            }
        }
    }

    private boolean containsResponseBodySchema(Content content) {
        return content.entrySet().stream().anyMatch(stringMediaTypeEntry -> ((MediaType)stringMediaTypeEntry.getValue()).getSchema() != null);
    }

    private String[] getConsumes(String[] classConsumes) {
        return classConsumes == null ? new String[]{} : classConsumes;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, MethodAttributes methodAttributes, Components components) {
        return this.buildRequestBodyFromDoc(requestBody, null, methodAttributes, components, null, null);
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, MethodAttributes methodAttributes, Components components, JsonView jsonViewAnnotation, Locale locale) {
        return this.buildRequestBodyFromDoc(requestBody, null, methodAttributes, components, jsonViewAnnotation, locale);
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, RequestBody requestBodyOp, MethodAttributes methodAttributes, Components components, Locale locale) {
        return this.buildRequestBodyFromDoc(requestBody, requestBodyOp, methodAttributes, components, null, locale);
    }

    public void calculateRequestBodyInfo(Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        RequestBody requestBody = requestBodyInfo.getRequestBody();
        MethodParameter methodParameter = parameterInfo.getMethodParameter();
        RequestPart requestPart = methodParameter.getParameterAnnotation(RequestPart.class);
        String paramName = null;
        if (requestPart != null) {
            paramName = StringUtils.defaultIfEmpty(requestPart.value(), requestPart.name());
            parameterInfo.setRequired(requestPart.required());
            parameterInfo.setRequestPart(true);
        }
        paramName = StringUtils.defaultIfEmpty(paramName, parameterInfo.getpName());
        parameterInfo.setpName(paramName);
        io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = methodParameter.getParameterAnnotation(io.swagger.v3.oas.annotations.parameters.RequestBody.class);
        requestBody = this.buildRequestBody(requestBodyDoc, components, methodAttributes, parameterInfo, requestBodyInfo);
        requestBodyInfo.setRequestBody(requestBody);
    }

    private RequestBody buildRequestBody(io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc, Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        String paramJavadocDescription;
        RequestBody requestBody = requestBodyInfo.getRequestBody();
        if (requestBody == null) {
            requestBody = new RequestBody();
            requestBodyInfo.setRequestBody(requestBody);
        }
        if (requestBodyDoc != null) {
            requestBody = this.buildRequestBodyFromDoc(requestBodyDoc, methodAttributes, components).orElse(requestBody);
        }
        Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo, requestBodyInfo, methodAttributes.getJsonViewAnnotationForRequestBody());
        Map<String, Encoding> parameterEncoding = this.getParameterEncoding(parameterInfo);
        this.buildContent(requestBody, methodAttributes, schema, parameterEncoding);
        if (StringUtils.isBlank(requestBody.getDescription()) && this.parameterBuilder.getJavadocProvider() != null && this.parameterBuilder.isRequestBodyPresent(parameterInfo) && !StringUtils.isBlank(paramJavadocDescription = this.parameterBuilder.getParamJavadoc(this.parameterBuilder.getJavadocProvider(), parameterInfo.getMethodParameter()))) {
            requestBody.setDescription(paramJavadocDescription);
        }
        return requestBody;
    }

    private void buildContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema, Map<String, Encoding> parameterEncoding) {
        Content content = requestBody.getContent() == null ? new Content() : requestBody.getContent();
        for (String value : methodAttributes.getMethodConsumes()) {
            MediaType mediaTypeObject = new MediaType();
            MediaType mediaType = (MediaType)content.get(value);
            mediaTypeObject.setSchema(schema);
            if (mediaType != null) {
                if (mediaType.getExample() != null) {
                    mediaTypeObject.setExample(mediaType.getExample());
                }
                if (mediaType.getExamples() != null) {
                    mediaTypeObject.setExamples(mediaType.getExamples());
                }
                if (mediaType.getEncoding() != null) {
                    mediaTypeObject.setEncoding(mediaType.getEncoding());
                }
                if (mediaType.getSchema() != null) {
                    mediaTypeObject.setSchema(mediaType.getSchema());
                }
            } else if (!CollectionUtils.isEmpty(parameterEncoding)) {
                mediaTypeObject.setEncoding(parameterEncoding);
            }
            content.addMediaType(value, mediaTypeObject);
        }
        requestBody.setContent(content);
    }

    @NotNull
    private Map<String, Encoding> getParameterEncoding(ParameterInfo parameterInfo) {
        Content parameterContent;
        if (parameterInfo.getParameterModel() != null && (parameterContent = parameterInfo.getParameterModel().getContent()) != null && parameterContent.size() == 1) {
            Map<String, Encoding> encoding = ((MediaType)parameterContent.values().iterator().next()).getEncoding();
            if (!CollectionUtils.isEmpty(encoding)) {
                return encoding;
            }
            String encodingContentType = (String)parameterContent.keySet().iterator().next();
            if (StringUtils.isNotBlank(encodingContentType)) {
                return Map.of(parameterInfo.getpName(), new Encoding().contentType(encodingContentType));
            }
        }
        return Map.of();
    }
}

