/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.GenericParameterService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.RequestBodyService;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public class OperationService {
    private final GenericParameterService parameterBuilder;
    private final RequestBodyService requestBodyService;
    private final SecurityService securityParser;
    private final PropertyResolverUtils propertyResolverUtils;

    public OperationService(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, SecurityService securityParser, PropertyResolverUtils propertyResolverUtils) {
        this.parameterBuilder = parameterBuilder;
        this.requestBodyService = requestBodyService;
        this.securityParser = securityParser;
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public OpenAPI parse(io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation, OpenAPI openAPI, MethodAttributes methodAttributes) {
        Components components = openAPI.getComponents();
        Locale locale = methodAttributes.getLocale();
        if (StringUtils.isNotBlank(apiOperation.summary())) {
            operation.setSummary(this.propertyResolverUtils.resolve(apiOperation.summary(), locale));
        }
        if (StringUtils.isNotBlank(apiOperation.description())) {
            operation.setDescription(this.propertyResolverUtils.resolve(apiOperation.description(), locale));
        }
        if (StringUtils.isNotBlank(apiOperation.operationId())) {
            operation.setOperationId(apiOperation.operationId());
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(apiOperation.deprecated());
        }
        this.buildTags(apiOperation, operation);
        if (operation.getExternalDocs() == null) {
            AnnotationsUtils.getExternalDocumentation(apiOperation.externalDocs(), this.propertyResolverUtils.isOpenapi31()).ifPresent(operation::setExternalDocs);
        }
        AnnotationsUtils.getServers(apiOperation.servers()).ifPresent(servers -> servers.forEach(operation::addServersItem));
        for (Parameter parameterDoc : apiOperation.parameters()) {
            io.swagger.v3.oas.models.parameters.Parameter parameter = this.parameterBuilder.buildParameterFromDoc(parameterDoc, components, methodAttributes.getJsonViewAnnotation(), locale);
            operation.addParametersItem(parameter);
        }
        this.requestBodyService.buildRequestBodyFromDoc(apiOperation.requestBody(), operation.getRequestBody(), methodAttributes, components, locale).ifPresent(operation::setRequestBody);
        this.buildResponse(components, apiOperation, operation, methodAttributes);
        this.securityParser.buildSecurityRequirement(apiOperation.security(), operation);
        this.buildExtensions(apiOperation, operation, locale);
        return openAPI;
    }

    public boolean isHidden(Method method) {
        io.swagger.v3.oas.annotations.Operation apiOperation = AnnotationUtils.findAnnotation(method, io.swagger.v3.oas.annotations.Operation.class);
        return apiOperation != null && apiOperation.hidden() || AnnotationUtils.findAnnotation(method, Hidden.class) != null;
    }

    public Optional<Map<String, io.swagger.v3.oas.models.callbacks.Callback>> buildCallbacks(Set<Callback> apiCallbacks, OpenAPI openAPI, MethodAttributes methodAttributes) {
        LinkedHashMap callbacks = new LinkedHashMap();
        boolean doBreak = false;
        for (Callback methodCallback : apiCallbacks) {
            HashMap<String, io.swagger.v3.oas.models.callbacks.Callback> callbackMap = new HashMap<String, io.swagger.v3.oas.models.callbacks.Callback>();
            if (methodCallback == null) {
                callbacks.putAll(callbackMap);
                doBreak = true;
            }
            io.swagger.v3.oas.models.callbacks.Callback callbackObject = new io.swagger.v3.oas.models.callbacks.Callback();
            if (!doBreak && StringUtils.isNotBlank(methodCallback.ref())) {
                callbackObject.set$ref(methodCallback.ref());
                callbackMap.put(methodCallback.name(), callbackObject);
                callbacks.putAll(callbackMap);
                doBreak = true;
            }
            if (doBreak) break;
            PathItem pathItemObject = new PathItem();
            for (io.swagger.v3.oas.annotations.Operation callbackOperation : methodCallback.operation()) {
                Operation callbackNewOperation = new Operation();
                this.parse(callbackOperation, callbackNewOperation, openAPI, methodAttributes);
                this.setPathItemOperation(pathItemObject, callbackOperation.method(), callbackNewOperation);
            }
            callbackObject.addPathItem(methodCallback.callbackUrlExpression(), pathItemObject);
            callbackMap.put(methodCallback.name(), callbackObject);
            callbacks.putAll(callbackMap);
        }
        if (CollectionUtils.isEmpty(callbacks)) {
            return Optional.empty();
        }
        return Optional.of(callbacks);
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, Operation operation) {
        switch (method) {
            case "post": {
                pathItemObject.post(operation);
                break;
            }
            case "get": {
                pathItemObject.get(operation);
                break;
            }
            case "delete": {
                pathItemObject.delete(operation);
                break;
            }
            case "put": {
                pathItemObject.put(operation);
                break;
            }
            case "patch": {
                pathItemObject.patch(operation);
                break;
            }
            case "trace": {
                pathItemObject.trace(operation);
                break;
            }
            case "head": {
                pathItemObject.head(operation);
                break;
            }
            case "options": {
                pathItemObject.options(operation);
                break;
            }
        }
    }

    private void buildExtensions(io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation, Locale locale) {
        if (apiOperation.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.propertyResolverUtils.isOpenapi31(), apiOperation.extensions());
            if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
                extensionsResolved.forEach(operation::addExtension);
            } else {
                extensions.forEach(operation::addExtension);
            }
        }
    }

    private void buildTags(io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation) {
        Optional<List<String>> mlist = this.getStringListFromStringArray(apiOperation.tags());
        if (mlist.isPresent()) {
            List<String> tags = mlist.get().stream().filter(t -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t)).toList();
            tags.forEach(operation::addTagsItem);
        }
    }

    private Optional<ApiResponses> getApiResponses(io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, MethodAttributes methodAttributes, Operation operation, Components components) {
        ApiResponses apiResponsesObject = new ApiResponses();
        String[] classProduces = methodAttributes.getClassProduces();
        String[] methodProduces = methodAttributes.getMethodProduces();
        ApiResponses apiResponsesOp = operation.getResponses();
        for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
            ApiResponse apiResponseObject = new ApiResponse();
            if (StringUtils.isNotBlank(response.ref())) {
                this.setRef(apiResponsesObject, response, apiResponseObject);
                continue;
            }
            this.setDescription(response, apiResponseObject, methodAttributes.getJavadocReturn());
            this.setExtensions(response, apiResponseObject, methodAttributes.getLocale());
            this.buildResponseContent(methodAttributes, components, classProduces, methodProduces, apiResponsesOp, response, apiResponseObject);
            SpringDocAnnotationsUtils.getHeaders(response.headers(), components, null, this.propertyResolverUtils.isOpenapi31()).ifPresent(apiResponseObject::headers);
            this.calculateHeader(apiResponseObject);
            if (!this.isResponseObject(apiResponseObject)) continue;
            this.setLinks(response, apiResponseObject);
            if (StringUtils.isNotBlank(response.responseCode())) {
                apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
                continue;
            }
            apiResponsesObject._default(apiResponseObject);
        }
        return Optional.of(apiResponsesObject);
    }

    private void buildResponseContent(MethodAttributes methodAttributes, Components components, String[] classProduces, String[] methodProduces, ApiResponses apiResponsesOp, io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        if (apiResponsesOp == null) {
            SpringDocAnnotationsUtils.getContent(response.content(), classProduces == null ? new String[]{} : classProduces, methodProduces == null ? new String[]{} : methodProduces, null, components, null, this.propertyResolverUtils.isOpenapi31()).ifPresent(apiResponseObject::content);
        } else {
            GenericResponseService.buildContentFromDoc(components, apiResponsesOp, methodAttributes, response, apiResponseObject, this.propertyResolverUtils.isOpenapi31());
        }
    }

    private boolean isResponseObject(ApiResponse apiResponseObject) {
        return StringUtils.isNotBlank(apiResponseObject.getDescription()) || apiResponseObject.getContent() != null || apiResponseObject.getHeaders() != null;
    }

    private void setLinks(io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        Map<String, Link> links = AnnotationsUtils.getLinks(response.links(), this.propertyResolverUtils.isOpenapi31());
        if (links.size() > 0) {
            apiResponseObject.setLinks(links);
        }
    }

    private void setDescription(io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject, String javadocReturn) {
        if (StringUtils.isNotBlank(response.description())) {
            apiResponseObject.setDescription(response.description());
        } else if (StringUtils.isNotBlank(javadocReturn)) {
            apiResponseObject.setDescription(javadocReturn);
        } else {
            GenericResponseService.setDescription(response.responseCode(), apiResponseObject);
        }
    }

    private void calculateHeader(ApiResponse apiResponseObject) {
        Map<String, Header> headers = apiResponseObject.getHeaders();
        if (!CollectionUtils.isEmpty(headers)) {
            for (Map.Entry<String, Header> entry : headers.entrySet()) {
                Header header = entry.getValue();
                if (header.getSchema() != null) continue;
                Schema schema = AnnotationsUtils.resolveSchemaFromType(String.class, null, null, this.propertyResolverUtils.isOpenapi31());
                header.setSchema(schema);
                entry.setValue(header);
            }
        }
    }

    private void setRef(ApiResponses apiResponsesObject, io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject) {
        apiResponseObject.set$ref(response.ref());
        if (StringUtils.isNotBlank(response.responseCode())) {
            apiResponsesObject.addApiResponse(response.responseCode(), apiResponseObject);
        } else {
            apiResponsesObject._default(apiResponseObject);
        }
    }

    private void setExtensions(io.swagger.v3.oas.annotations.responses.ApiResponse response, ApiResponse apiResponseObject, Locale locale) {
        if (response.extensions().length > 0) {
            Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.propertyResolverUtils.isOpenapi31(), response.extensions());
            if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
                extensionsResolved.forEach(apiResponseObject::addExtension);
            } else {
                extensions.forEach(apiResponseObject::addExtension);
            }
        }
    }

    private void buildResponse(Components components, io.swagger.v3.oas.annotations.Operation apiOperation, Operation operation, MethodAttributes methodAttributes) {
        this.getApiResponses(apiOperation.responses(), methodAttributes, operation, components).ifPresent(responses -> {
            if (operation.getResponses() == null) {
                operation.setResponses((ApiResponses)responses);
            } else {
                responses.forEach(operation.getResponses()::addApiResponse);
            }
        });
    }

    private Optional<List<String>> getStringListFromStringArray(String[] array) {
        if (array == null) {
            return Optional.empty();
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean isEmpty = true;
        for (String value : array) {
            if (StringUtils.isNotBlank(value)) {
                isEmpty = false;
            }
            list.add(value);
        }
        if (isEmpty) {
            return Optional.empty();
        }
        return Optional.of(list);
    }

    public Operation mergeOperation(Operation operation, Operation operationModel) {
        if (operationModel.getOperationId().length() < operation.getOperationId().length()) {
            operation.setOperationId(operationModel.getOperationId());
        }
        ApiResponses apiResponses = operation.getResponses();
        for (Map.Entry apiResponseEntry : operationModel.getResponses().entrySet()) {
            if (apiResponses.containsKey(apiResponseEntry.getKey())) {
                Content existingContent = ((ApiResponse)apiResponses.get(apiResponseEntry.getKey())).getContent();
                Content newContent = ((ApiResponse)apiResponseEntry.getValue()).getContent();
                if (newContent == null) continue;
                newContent.forEach((mediaTypeStr, mediaType) -> SpringDocAnnotationsUtils.mergeSchema(existingContent, mediaType.getSchema(), mediaTypeStr));
                continue;
            }
            apiResponses.addApiResponse((String)apiResponseEntry.getKey(), (ApiResponse)apiResponseEntry.getValue());
        }
        return operation;
    }

    public JavadocProvider getJavadocProvider() {
        return this.parameterBuilder.getJavadocProvider();
    }

    public PropertyResolverUtils getPropertyResolverUtils() {
        return this.parameterBuilder.getPropertyResolverUtils();
    }
}

