/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.service;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.models.ControllerAdviceInfo;
import org.springdoc.core.models.MethodAdviceInfo;
import org.springdoc.core.models.MethodAttributes;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.providers.ObjectMapperProvider;
import org.springdoc.core.service.OperationService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springdoc.core.utils.SpringDocAnnotationsUtils;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ProblemDetail;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.ControllerAdviceBean;
import org.springframework.web.method.HandlerMethod;

public class GenericResponseService
implements ApplicationContextAware {
    private static final String EXTENSION_EXCEPTION_CLASSES = "x-exception-class";
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericResponseService.class);
    private static Class<?> responseEntityExceptionHandlerClass;
    private final OperationService operationService;
    private final SpringDocConfigProperties springDocConfigProperties;
    private final PropertyResolverUtils propertyResolverUtils;
    private final List<ControllerAdviceInfo> controllerAdviceInfos = new CopyOnWriteArrayList<ControllerAdviceInfo>();
    private final List<ControllerAdviceInfo> localExceptionHandlers = new CopyOnWriteArrayList<ControllerAdviceInfo>();
    private final Lock reentrantLock = new ReentrantLock();
    private List<ControllerAdviceBean> controllerAdviceBeans;

    public GenericResponseService(OperationService operationService, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        this.operationService = operationService;
        this.springDocConfigProperties = springDocConfigProperties;
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public static void buildContentFromDoc(Components components, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, io.swagger.v3.oas.annotations.responses.ApiResponse apiResponseAnnotations, ApiResponse apiResponse, boolean openapi31) {
        methodAttributes.setUseReturnTypeSchema(apiResponseAnnotations.useReturnTypeSchema());
        io.swagger.v3.oas.annotations.media.Content[] contentdoc = apiResponseAnnotations.content();
        Optional<Content> optionalContent = SpringDocAnnotationsUtils.getContent(contentdoc, new String[0], methodAttributes.getMethodProduces(), null, components, methodAttributes.getJsonViewAnnotation(), openapi31);
        if (apiResponsesOp.containsKey(apiResponseAnnotations.responseCode())) {
            Content existingContent = ((ApiResponse)apiResponsesOp.get(apiResponseAnnotations.responseCode())).getContent();
            if (optionalContent.isPresent()) {
                Content newContent = optionalContent.get();
                if (methodAttributes.isMethodOverloaded() && existingContent != null) {
                    Arrays.stream(methodAttributes.getMethodProduces()).filter(mediaTypeStr -> newContent.get(mediaTypeStr) != null).forEach(mediaTypeStr -> {
                        if (((MediaType)newContent.get(mediaTypeStr)).getSchema() != null) {
                            SpringDocAnnotationsUtils.mergeSchema(existingContent, ((MediaType)newContent.get(mediaTypeStr)).getSchema(), mediaTypeStr);
                        }
                    });
                    apiResponse.content(existingContent);
                } else {
                    apiResponse.content(newContent);
                }
            } else {
                apiResponse.content(existingContent);
            }
        } else {
            optionalContent.ifPresent(apiResponse::content);
        }
    }

    public static void setDescription(String httpCode, ApiResponse apiResponse) {
        try {
            HttpStatus httpStatus = HttpStatus.valueOf(Integer.parseInt(httpCode));
            apiResponse.setDescription(httpStatus.getReasonPhrase());
        }
        catch (IllegalArgumentException e) {
            apiResponse.setDescription("default response");
        }
    }

    public static void setResponseEntityExceptionHandlerClass(Class<?> responseEntityExceptionHandlerClass) {
        GenericResponseService.responseEntityExceptionHandlerClass = responseEntityExceptionHandlerClass;
    }

    public io.swagger.v3.oas.models.responses.ApiResponses build(Components components, HandlerMethod handlerMethod, Operation operation, MethodAttributes methodAttributes) {
        Map<String, ApiResponse> genericMapResponse = this.getGenericMapResponse(handlerMethod);
        if (this.springDocConfigProperties.isOverrideWithGenericResponse()) {
            genericMapResponse = this.filterAndEnrichGenericMapResponseByDeclarations(handlerMethod, genericMapResponse);
        }
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = methodAttributes.calculateGenericMapResponse(genericMapResponse);
        io.swagger.v3.oas.models.responses.ApiResponses apiResponsesFromDoc = operation.getResponses();
        if (!CollectionUtils.isEmpty(apiResponsesFromDoc)) {
            apiResponsesFromDoc.forEach(apiResponses::addApiResponse);
        }
        this.computeResponseFromDoc(components, handlerMethod.getReturnType(), apiResponses, methodAttributes, this.springDocConfigProperties.isOpenapi31(), methodAttributes.getLocale());
        this.buildApiResponses(components, handlerMethod.getReturnType(), apiResponses, methodAttributes);
        return apiResponses;
    }

    private Map<String, ApiResponse> filterAndEnrichGenericMapResponseByDeclarations(HandlerMethod handlerMethod, Map<String, ApiResponse> genericMapResponse) {
        if (this.operationService.getJavadocProvider() != null) {
            JavadocProvider javadocProvider = this.operationService.getJavadocProvider();
            for (Map.Entry<String, ApiResponse> genericResponse : genericMapResponse.entrySet()) {
                Map<String, Object> extensions = genericResponse.getValue().getExtensions();
                Collection genericExceptions = (Collection)extensions.get(EXTENSION_EXCEPTION_CLASSES);
                for (Class<?> declaredException : handlerMethod.getMethod().getExceptionTypes()) {
                    if (!genericExceptions.contains(declaredException.getName())) continue;
                    Map<String, String> javadocThrows = javadocProvider.getMethodJavadocThrows(handlerMethod.getMethod());
                    String description = javadocThrows.get(declaredException.getName());
                    if (description == null) {
                        description = javadocThrows.get(declaredException.getSimpleName());
                    }
                    if (description == null || description.trim().isEmpty()) continue;
                    genericResponse.getValue().setDescription(description);
                }
            }
        }
        return genericMapResponse;
    }

    public void buildGenericResponse(Components components, Map<String, Object> findControllerAdvice, Locale locale) {
        for (Map.Entry<String, Object> entry : findControllerAdvice.entrySet()) {
            ArrayList methods = new ArrayList();
            Object controllerAdvice = entry.getValue();
            Class<?> objClz = controllerAdvice.getClass();
            if (AopUtils.isAopProxy(controllerAdvice)) {
                objClz = AopUtils.getTargetClass(controllerAdvice);
            }
            ControllerAdviceInfo controllerAdviceInfo = new ControllerAdviceInfo(controllerAdvice);
            Arrays.stream(ReflectionUtils.getAllDeclaredMethods(objClz)).filter(m -> m.isAnnotationPresent(ExceptionHandler.class) || this.isResponseEntityExceptionHandlerMethod((Method)m)).forEach(methods::add);
            for (Method method : methods) {
                if (this.operationService.isHidden(method)) continue;
                RequestMapping reqMappingMethod = AnnotatedElementUtils.findMergedAnnotation(method, RequestMapping.class);
                String[] methodProduces = new String[]{this.springDocConfigProperties.getDefaultProducesMediaType()};
                if (reqMappingMethod != null) {
                    methodProduces = reqMappingMethod.produces();
                }
                MethodParameter methodParameter = new MethodParameter(method, -1);
                MethodAdviceInfo methodAdviceInfo = new MethodAdviceInfo(method);
                controllerAdviceInfo.addMethodAdviceInfos(methodAdviceInfo);
                Set<Class<?>> exceptions = this.getExceptionsFromExceptionHandler(methodParameter);
                methodAdviceInfo.setExceptions(exceptions);
                Map<String, ApiResponse> controllerAdviceInfoApiResponseMap = controllerAdviceInfo.getApiResponseMap();
                io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp = new io.swagger.v3.oas.models.responses.ApiResponses();
                MethodAttributes methodAttributes = new MethodAttributes(methodProduces, this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType(), controllerAdviceInfoApiResponseMap, locale);
                methodAttributes.setJsonViewAnnotation(AnnotatedElementUtils.findMergedAnnotation(method, JsonView.class));
                if (this.operationService.getJavadocProvider() != null) {
                    JavadocProvider javadocProvider = this.operationService.getJavadocProvider();
                    methodAttributes.setJavadocReturn(javadocProvider.getMethodJavadocReturn(methodParameter.getMethod()));
                }
                this.computeResponseFromDoc(components, methodParameter, apiResponsesOp, methodAttributes, this.springDocConfigProperties.isOpenapi31(), locale);
                this.buildGenericApiResponses(components, methodParameter, apiResponsesOp, methodAttributes);
                methodAdviceInfo.setApiResponses(apiResponsesOp);
            }
            if (AnnotatedElementUtils.hasAnnotation(objClz, ControllerAdvice.class)) {
                this.controllerAdviceInfos.add(controllerAdviceInfo);
                continue;
            }
            this.localExceptionHandlers.add(controllerAdviceInfo);
        }
    }

    private boolean isResponseEntityExceptionHandlerMethod(Method m) {
        if (AnnotatedElementUtils.hasAnnotation(m.getDeclaringClass(), ControllerAdvice.class)) {
            return responseEntityExceptionHandlerClass != null && responseEntityExceptionHandlerClass.isAssignableFrom(m.getDeclaringClass()) && ReflectionUtils.findMethod(responseEntityExceptionHandlerClass, m.getName(), m.getParameterTypes()) != null;
        }
        return false;
    }

    private Map<String, ApiResponse> computeResponseFromDoc(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, boolean openapi31, Locale locale) {
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responsesArray = this.getApiResponses(Objects.requireNonNull(methodParameter.getMethod()));
        if (!responsesArray.isEmpty()) {
            methodAttributes.setWithApiResponseDoc(true);
            for (io.swagger.v3.oas.annotations.responses.ApiResponse apiResponseAnnotations : responsesArray) {
                String httpCode = apiResponseAnnotations.responseCode();
                ApiResponse apiResponse = new ApiResponse();
                if (StringUtils.isNotBlank(apiResponseAnnotations.ref())) {
                    apiResponse.$ref(apiResponseAnnotations.ref());
                    apiResponsesOp.addApiResponse(apiResponseAnnotations.responseCode(), apiResponse);
                    continue;
                }
                apiResponse.setDescription(this.propertyResolverUtils.resolve(apiResponseAnnotations.description(), methodAttributes.getLocale()));
                GenericResponseService.buildContentFromDoc(components, apiResponsesOp, methodAttributes, apiResponseAnnotations, apiResponse, openapi31);
                Map<String, Object> extensions = AnnotationsUtils.getExtensions(this.propertyResolverUtils.isOpenapi31(), apiResponseAnnotations.extensions());
                if (!CollectionUtils.isEmpty(extensions)) {
                    if (this.propertyResolverUtils.isResolveExtensionsProperties()) {
                        Map<String, Object> extensionsResolved = this.propertyResolverUtils.resolveExtensions(locale, extensions);
                        extensionsResolved.forEach(apiResponse::addExtension);
                    } else {
                        apiResponse.extensions(extensions);
                    }
                }
                SpringDocAnnotationsUtils.getHeaders(apiResponseAnnotations.headers(), components, methodAttributes.getJsonViewAnnotation(), openapi31).ifPresent(apiResponse::headers);
                apiResponsesOp.addApiResponse(httpCode, apiResponse);
            }
        }
        return apiResponsesOp;
    }

    private void buildGenericApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes) {
        String defaultProducesMediaType;
        MediaType mediaType;
        Content content;
        ApiResponse apiResponse = null;
        if (!CollectionUtils.isEmpty(apiResponsesOp)) {
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                String httpCode = (String)entry.getKey();
                apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, apiResponse, true);
            }
        } else {
            String httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), Objects.requireNonNull(methodParameter.getMethod()).getClass(), true);
            if (Objects.nonNull(httpCode)) {
                apiResponse = methodAttributes.getGenericMapResponse().containsKey(httpCode) ? methodAttributes.getGenericMapResponse().get(httpCode) : new ApiResponse();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, apiResponse, true);
            }
        }
        if (apiResponse != null && (content = apiResponse.getContent()) != null && (mediaType = (MediaType)content.get(defaultProducesMediaType = this.springDocConfigProperties.getDefaultProducesMediaType())) != null && ProblemDetail.class.isAssignableFrom(methodParameter.getParameterType())) {
            content.addMediaType("application/problem+json", mediaType);
            content.remove(defaultProducesMediaType);
        }
    }

    private void buildApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes) {
        Map<String, ApiResponse> genericMapResponse = methodAttributes.getGenericMapResponse();
        if (!CollectionUtils.isEmpty(apiResponsesOp) && apiResponsesOp.size() > genericMapResponse.size()) {
            String httpCode;
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                boolean methodAttributesCondition;
                String httpCode2 = (String)entry.getKey();
                boolean bl = methodAttributesCondition = !methodAttributes.isMethodOverloaded() || methodAttributes.isMethodOverloaded() && this.isValidHttpCode(httpCode2, methodParameter);
                if (genericMapResponse.containsKey(httpCode2) || !methodAttributesCondition) continue;
                ApiResponse apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode2, apiResponse, false);
            }
            if (AnnotatedElementUtils.hasAnnotation(methodParameter.getMethod(), ResponseStatus.class) && Objects.nonNull(httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), Objects.requireNonNull(methodParameter.getMethod()).getClass(), false)) && !apiResponsesOp.containsKey(httpCode) && !apiResponsesOp.containsKey("default")) {
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, new ApiResponse(), false);
            }
        } else {
            String httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), Objects.requireNonNull(methodParameter.getMethod()).getClass(), false);
            if (Objects.nonNull(httpCode)) {
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, new ApiResponse(), false);
            }
        }
    }

    public Set<io.swagger.v3.oas.annotations.responses.ApiResponse> getApiResponses(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set<ApiResponses> apiResponsesDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, ApiResponses.class);
        Set responses = apiResponsesDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toCollection(LinkedHashSet::new));
        Set<ApiResponses> apiResponsesDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, ApiResponses.class);
        responses.addAll(apiResponsesDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toCollection(LinkedHashSet::new)));
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> apiResponseDoc = AnnotatedElementUtils.findMergedRepeatableAnnotations(method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        responses.addAll(apiResponseDoc);
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> apiResponseDocDeclaringClass = AnnotatedElementUtils.findMergedRepeatableAnnotations(declaringClass, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        responses.addAll(apiResponseDocDeclaringClass);
        return responses;
    }

    private Content buildContent(Components components, MethodParameter methodParameter, String[] methodProduces, JsonView jsonView) {
        Type returnType = GenericTypeResolver.resolveType(methodParameter.getGenericParameterType(), methodParameter.getContainingClass());
        return this.buildContent(components, SpringDocUtils.getParameterAnnotations(methodParameter), methodProduces, jsonView, returnType);
    }

    public Content buildContent(Components components, Annotation[] annotations, String[] methodProduces, JsonView jsonView, Type returnType) {
        Schema<?> schemaN;
        Content content = new Content();
        if (this.isVoid(returnType)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty(methodProduces) && (schemaN = this.calculateSchema(components, returnType, jsonView, annotations)) != null) {
            MediaType mediaType = new MediaType();
            mediaType.setSchema(schemaN);
            this.setContent(methodProduces, content, mediaType);
        }
        return content;
    }

    private Schema<?> calculateSchema(Components components, Type returnType, JsonView jsonView, Annotation[] annotations) {
        if (!this.isVoid(returnType) && !SpringDocAnnotationsUtils.isAnnotationToIgnore(returnType)) {
            return SpringDocAnnotationsUtils.extractSchema(components, returnType, jsonView, annotations, this.propertyResolverUtils.getSpecVersion());
        }
        return null;
    }

    private void setContent(String[] methodProduces, Content content, MediaType mediaType) {
        Arrays.stream(methodProduces).forEach(mediaTypeStr -> content.addMediaType((String)mediaTypeStr, mediaType));
    }

    private void buildApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, String httpCode, ApiResponse apiResponse, boolean isGeneric) {
        if (StringUtils.isBlank(apiResponse.get$ref())) {
            if (apiResponse.getContent() == null) {
                Content content = this.buildContent(components, methodParameter, methodAttributes.getMethodProduces(), methodAttributes.getJsonViewAnnotation());
                apiResponse.setContent(content);
            } else if (CollectionUtils.isEmpty(apiResponse.getContent())) {
                apiResponse.setContent(null);
            }
            if (StringUtils.isBlank(apiResponse.getDescription())) {
                if (!StringUtils.isBlank(methodAttributes.getJavadocReturn())) {
                    apiResponse.setDescription(methodAttributes.getJavadocReturn());
                } else {
                    GenericResponseService.setDescription(httpCode, apiResponse);
                }
            }
        }
        if (apiResponse.getContent() != null && (methodAttributes.isUseReturnTypeSchema() || (isGeneric || methodAttributes.isMethodOverloaded()) && methodAttributes.isNoApiResponseDoc())) {
            Content existingContent = apiResponse.getContent();
            Type type = GenericTypeResolver.resolveType(methodParameter.getGenericParameterType(), methodParameter.getContainingClass());
            Schema<?> schemaN = this.calculateSchema(components, type, methodAttributes.getJsonViewAnnotation(), SpringDocUtils.getParameterAnnotations(methodParameter));
            if (schemaN != null && ArrayUtils.isNotEmpty(methodAttributes.getMethodProduces())) {
                Arrays.stream(methodAttributes.getMethodProduces()).forEach(mediaTypeStr -> SpringDocAnnotationsUtils.mergeSchema(existingContent, schemaN, mediaTypeStr));
            }
        }
        if (this.springDocConfigProperties.isOverrideWithGenericResponse() && methodParameter.getExecutable().isAnnotationPresent(ExceptionHandler.class)) {
            Set<Class<?>> exceptions = this.getExceptionsFromExceptionHandler(methodParameter);
            apiResponse.addExtension(EXTENSION_EXCEPTION_CLASSES, exceptions);
        }
        apiResponsesOp.addApiResponse(httpCode, apiResponse);
    }

    public String evaluateResponseStatus(Method method, Class<?> beanType, boolean isGeneric) {
        String responseStatus = null;
        ResponseStatus annotation = AnnotatedElementUtils.findMergedAnnotation(method, ResponseStatus.class);
        if (annotation == null && beanType != null) {
            annotation = AnnotatedElementUtils.findMergedAnnotation(beanType, ResponseStatus.class);
        }
        if (annotation != null) {
            responseStatus = String.valueOf(annotation.code().value());
        }
        if (annotation == null && !isGeneric) {
            responseStatus = String.valueOf(HttpStatus.OK.value());
        }
        return responseStatus;
    }

    private boolean isVoid(Type returnType) {
        ParameterizedType parameterizedType;
        Type[] types;
        boolean result = false;
        if (Void.TYPE.equals(returnType) || Void.class.equals((Object)returnType)) {
            result = true;
        } else if (returnType instanceof ParameterizedType && (types = (parameterizedType = (ParameterizedType)returnType).getActualTypeArguments()) != null && ConverterUtils.isResponseTypeWrapper(ResolvableType.forType(returnType).getRawClass())) {
            result = this.isVoid(types[0]);
        }
        return result;
    }

    private ControllerAdviceBean getControllerAdviceBean(List<ControllerAdviceBean> controllerAdviceBeans, Object controllerAdvice) {
        return controllerAdviceBeans.stream().filter(controllerAdviceBean -> controllerAdviceBean.getBeanType() != null && controllerAdviceBean.getBeanType().isAssignableFrom(controllerAdvice.getClass())).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ApiResponse> getGenericMapResponse(HandlerMethod handlerMethod) {
        this.reentrantLock.lock();
        try {
            Class<?> beanType = handlerMethod.getBeanType();
            List<ControllerAdviceInfo> controllerAdviceInfosInThisBean = this.localExceptionHandlers.stream().filter(controllerInfo -> {
                Class<?> objClz = controllerInfo.getControllerAdvice().getClass();
                if (AopUtils.isAopProxy(controllerInfo.getControllerAdvice())) {
                    objClz = AopUtils.getTargetClass(controllerInfo.getControllerAdvice());
                }
                return beanType.equals(objClz);
            }).toList();
            Map genericApiResponseMap = controllerAdviceInfosInThisBean.stream().map(ControllerAdviceInfo::getApiResponseMap).collect(LinkedHashMap::new, Map::putAll, Map::putAll);
            List<ControllerAdviceInfo> controllerAdviceInfosNotInThisBean = this.controllerAdviceInfos.stream().filter(controllerAdviceInfo -> this.getControllerAdviceBean(this.controllerAdviceBeans, controllerAdviceInfo.getControllerAdvice()).isApplicableToBeanType(beanType)).filter(controllerAdviceInfo -> !beanType.equals(controllerAdviceInfo.getControllerAdvice().getClass())).toList();
            Class<?>[] methodExceptions = handlerMethod.getMethod().getExceptionTypes();
            for (ControllerAdviceInfo controllerAdviceInfo2 : controllerAdviceInfosNotInThisBean) {
                List<MethodAdviceInfo> methodAdviceInfos = controllerAdviceInfo2.getMethodAdviceInfos();
                for (MethodAdviceInfo methodAdviceInfo : methodAdviceInfos) {
                    Set<Class<?>> exceptions = methodAdviceInfo.getExceptions();
                    boolean addToGenericMap = false;
                    for (Class<?> exception : exceptions) {
                        if (!this.isGlobalException(exception) && !Arrays.stream(methodExceptions).anyMatch(methodException -> methodException.isAssignableFrom(exception) || exception.isAssignableFrom((Class<?>)methodException))) continue;
                        addToGenericMap = true;
                        break;
                    }
                    if (!addToGenericMap && !exceptions.isEmpty()) continue;
                    methodAdviceInfo.getApiResponses().forEach((key, apiResponse) -> {
                        if (!genericApiResponseMap.containsKey(key)) {
                            genericApiResponseMap.put(key, apiResponse);
                        }
                    });
                }
            }
            Map map = SpringDocUtils.cloneViaJson((Object)genericApiResponseMap, io.swagger.v3.oas.models.responses.ApiResponses.class, ObjectMapperProvider.createJson(this.springDocConfigProperties));
            return map;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    private boolean isValidHttpCode(String httpCode, MethodParameter methodParameter) {
        boolean result = false;
        Method method = methodParameter.getMethod();
        if (method != null) {
            Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responseSet = this.getApiResponses(method);
            if (this.isHttpCodePresent(httpCode, responseSet)) {
                result = true;
            } else {
                io.swagger.v3.oas.annotations.Operation apiOperation = AnnotatedElementUtils.findMergedAnnotation(method, io.swagger.v3.oas.annotations.Operation.class);
                if (apiOperation != null && this.isHttpCodePresent(httpCode, responseSet = new HashSet<io.swagger.v3.oas.annotations.responses.ApiResponse>(Arrays.asList(apiOperation.responses())))) {
                    result = true;
                }
                if (httpCode.equals(this.evaluateResponseStatus(method, method.getClass(), false))) {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean isHttpCodePresent(String httpCode, Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responseSet) {
        return !responseSet.isEmpty() && responseSet.stream().anyMatch(apiResponseAnnotations -> httpCode.equals(apiResponseAnnotations.responseCode()));
    }

    private Set<Class<?>> getExceptionsFromExceptionHandler(MethodParameter methodParameter) {
        ExceptionHandler exceptionHandler = methodParameter.getExecutable().getAnnotation(ExceptionHandler.class);
        HashSet exceptions = new HashSet();
        if (exceptionHandler != null) {
            if (exceptionHandler.value().length == 0) {
                for (Parameter parameter : methodParameter.getExecutable().getParameters()) {
                    if (!Throwable.class.isAssignableFrom(parameter.getType())) continue;
                    exceptions.add(parameter.getType());
                }
            } else {
                exceptions.addAll(Arrays.asList(exceptionHandler.value()));
            }
        }
        return exceptions;
    }

    private boolean isGlobalException(Class<?> exceptionClass) {
        return RuntimeException.class.isAssignableFrom(exceptionClass) || exceptionClass.isAssignableFrom(Exception.class) || Error.class.isAssignableFrom(exceptionClass);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.controllerAdviceBeans = ControllerAdviceBean.findAnnotatedBeans(applicationContext);
    }
}

