/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn.builders.schema;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.StringToClassMapItem;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.DependentRequired;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.ArrayUtils;

public class Builder {
    private Class<?> implementation = Void.class;
    private Class<?> not = Void.class;
    private Class<?>[] oneOf = new Class[0];
    private Class<?>[] anyOf = new Class[0];
    private Class<?>[] allOf = new Class[0];
    private String name = "";
    private String title = "";
    private double multipleOf = 0.0;
    private String maximum = "";
    private boolean exclusiveMaximum;
    private String minimum = "";
    private boolean exclusiveMinimum;
    private int maxLength = Integer.MAX_VALUE;
    private int minLength = 0;
    private String pattern = "";
    private int maxProperties = 0;
    private int minProperties = 0;
    private String[] requiredProperties = new String[0];
    private boolean required;
    private String description = "";
    private String format = "";
    private String ref = "";
    private boolean nullable;
    private Schema.AccessMode accessMode = Schema.AccessMode.AUTO;
    private String example = "";
    private ExternalDocumentation externalDocs = org.springdoc.core.fn.builders.externaldocumentation.Builder.externalDocumentationBuilder().build();
    private boolean deprecated;
    private String type = "";
    private String[] allowableValues = new String[0];
    private String defaultValue = "";
    private String discriminatorProperty = "";
    private DiscriminatorMapping[] discriminatorMapping = new DiscriminatorMapping[0];
    private boolean hidden;
    private boolean enumAsRef;
    private Class<?>[] subTypes = new Class[0];
    private Extension[] extensions = new Extension[0];
    private Schema.SchemaResolution schemaResolution;
    private Schema.AdditionalPropertiesValue additionalProperties = Schema.AdditionalPropertiesValue.USE_ADDITIONAL_PROPERTIES_ANNOTATION;
    private Schema.RequiredMode requiredMode = Schema.RequiredMode.AUTO;
    private Class<?>[] prefixItems = new Class[0];
    private String[] types = new String[0];
    private int exclusiveMaximumValue = 0;
    private int exclusiveMinimumValue = 0;
    private Class<?> contains = Void.class;
    private String $id = "";
    private String $schema = "";
    private String $anchor = "";
    private String $vocabulary = "";
    private String $dynamicAnchor = "";
    private String $dynamicRef = "";
    private String contentEncoding = "";
    private String contentMediaType = "";
    private Class<?> contentSchema = Void.class;
    private Class<?> propertyNames = Void.class;
    private int maxContains = Integer.MAX_VALUE;
    private int minContains = 0;
    private Class<?> additionalItems = Void.class;
    private Class<?> unevaluatedItems = Void.class;
    private Class<?> _if = Void.class;
    private Class<?> _else = Void.class;
    private Class<?> then = Void.class;
    private String $comment = "";
    private Class<?>[] exampleClasses = new Class[0];
    private DependentRequired[] dependentRequiredMap = new DependentRequired[0];
    private StringToClassMapItem[] dependentSchemas = new StringToClassMapItem[0];
    private StringToClassMapItem[] patternProperties = new StringToClassMapItem[0];
    private StringToClassMapItem[] properties = new StringToClassMapItem[0];
    private Class<?> unevaluatedProperties = Void.class;
    private Class<?> additionalPropertiesSchema = Void.class;
    private String[] examples = new String[0];
    private String _const = "";

    private Builder() {
    }

    public static Builder schemaBuilder() {
        return new Builder();
    }

    public Builder implementation(Class<?> implementation) {
        this.implementation = implementation;
        return this;
    }

    public Builder not(Class<?> not) {
        this.not = not;
        return this;
    }

    public Builder oneOf(Class<?>[] oneOf) {
        this.oneOf = oneOf;
        return this;
    }

    public Builder anyOf(Class<?>[] anyOf) {
        this.anyOf = anyOf;
        return this;
    }

    public Builder allOf(Class<?>[] allOf) {
        this.allOf = allOf;
        return this;
    }

    public Builder name(String name) {
        this.name = name;
        return this;
    }

    public Builder title(String title) {
        this.title = title;
        return this;
    }

    public Builder multipleOf(double multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public Builder maximum(String maximum) {
        this.maximum = maximum;
        return this;
    }

    public Builder exclusiveMaximum(boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Builder minimum(String minimum) {
        this.minimum = minimum;
        return this;
    }

    public Builder exclusiveMinimum(boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Builder maxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Builder minLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public Builder pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Builder maxProperties(int maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Builder minProperties(int minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public Builder requiredProperties(String[] requiredProperties) {
        this.requiredProperties = requiredProperties;
        return this;
    }

    public Builder required(boolean required) {
        this.required = required;
        return this;
    }

    public Builder description(String description) {
        this.description = description;
        return this;
    }

    public Builder format(String format) {
        this.format = format;
        return this;
    }

    public Builder ref(String ref) {
        this.ref = ref;
        return this;
    }

    public Builder nullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Builder accessMode(Schema.AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public Builder example(String example) {
        this.example = example;
        return this;
    }

    public Builder externalDocs(org.springdoc.core.fn.builders.externaldocumentation.Builder externalDocumentationBuilder) {
        this.externalDocs = externalDocumentationBuilder.build();
        return this;
    }

    public Builder deprecated(boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Builder type(String type) {
        this.type = type;
        return this;
    }

    public Builder allowableValues(String[] allowableValues) {
        this.allowableValues = allowableValues;
        return this;
    }

    public Builder defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Builder discriminatorProperty(String discriminatorProperty) {
        this.discriminatorProperty = discriminatorProperty;
        return this;
    }

    public Builder discriminatorMapping(org.springdoc.core.fn.builders.discriminatormapping.Builder discriminatorMappingBuilder) {
        this.discriminatorMapping = ArrayUtils.add(this.discriminatorMapping, discriminatorMappingBuilder.build());
        return this;
    }

    public Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Builder enumAsRef(boolean enumAsRef) {
        this.enumAsRef = enumAsRef;
        return this;
    }

    public Builder subTypes(Class<?>[] subTypes) {
        this.subTypes = subTypes;
        return this;
    }

    public Builder extensions(org.springdoc.core.fn.builders.extension.Builder extensionBuilder) {
        this.extensions = ArrayUtils.add(this.extensions, extensionBuilder.build());
        return this;
    }

    public Builder requiredMode(Schema.RequiredMode requiredMode) {
        this.requiredMode = requiredMode;
        return this;
    }

    public Builder schemaResolution(Schema.SchemaResolution schemaResolution) {
        this.schemaResolution = schemaResolution;
        return this;
    }

    public Builder dependentRequiredMap(DependentRequired[] dependentRequiredMap) {
        this.dependentRequiredMap = dependentRequiredMap;
        return this;
    }

    public Builder dependentSchemas(StringToClassMapItem[] dependentSchemas) {
        this.dependentSchemas = dependentSchemas;
        return this;
    }

    public Builder patternProperties(StringToClassMapItem[] patternProperties) {
        this.patternProperties = patternProperties;
        return this;
    }

    public Builder properties(StringToClassMapItem[] properties) {
        this.properties = properties;
        return this;
    }

    public Builder additionalProperties(Schema.AdditionalPropertiesValue additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public Schema build() {
        return new Schema(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return null;
            }

            @Override
            public Class<?> implementation() {
                return Builder.this.implementation;
            }

            @Override
            public Class<?> not() {
                return Builder.this.not;
            }

            @Override
            public Class<?>[] oneOf() {
                return Builder.this.oneOf;
            }

            @Override
            public Class<?>[] anyOf() {
                return Builder.this.anyOf;
            }

            @Override
            public Class<?>[] allOf() {
                return Builder.this.allOf;
            }

            @Override
            public String name() {
                return Builder.this.name;
            }

            @Override
            public String title() {
                return Builder.this.title;
            }

            @Override
            public double multipleOf() {
                return Builder.this.multipleOf;
            }

            @Override
            public String maximum() {
                return Builder.this.maximum;
            }

            @Override
            public boolean exclusiveMaximum() {
                return Builder.this.exclusiveMaximum;
            }

            @Override
            public String minimum() {
                return Builder.this.minimum;
            }

            @Override
            public boolean exclusiveMinimum() {
                return Builder.this.exclusiveMinimum;
            }

            @Override
            public int maxLength() {
                return Builder.this.maxLength;
            }

            @Override
            public int minLength() {
                return Builder.this.minLength;
            }

            @Override
            public String pattern() {
                return Builder.this.pattern;
            }

            @Override
            public int maxProperties() {
                return Builder.this.maxProperties;
            }

            @Override
            public int minProperties() {
                return Builder.this.minProperties;
            }

            @Override
            public String[] requiredProperties() {
                return Builder.this.requiredProperties;
            }

            @Override
            public boolean required() {
                return Builder.this.required;
            }

            @Override
            public Schema.RequiredMode requiredMode() {
                return Builder.this.requiredMode;
            }

            @Override
            public String description() {
                return Builder.this.description;
            }

            @Override
            public String format() {
                return Builder.this.format;
            }

            @Override
            public String ref() {
                return Builder.this.ref;
            }

            @Override
            public boolean nullable() {
                return Builder.this.nullable;
            }

            @Override
            public boolean readOnly() {
                return Schema.AccessMode.READ_ONLY.equals((Object)Builder.this.accessMode);
            }

            @Override
            public boolean writeOnly() {
                return Schema.AccessMode.WRITE_ONLY.equals((Object)Builder.this.accessMode);
            }

            @Override
            public Schema.AccessMode accessMode() {
                return Builder.this.accessMode;
            }

            @Override
            public String example() {
                return Builder.this.example;
            }

            @Override
            public ExternalDocumentation externalDocs() {
                return Builder.this.externalDocs;
            }

            @Override
            public boolean deprecated() {
                return Builder.this.deprecated;
            }

            @Override
            public String type() {
                return Builder.this.type;
            }

            @Override
            public String[] allowableValues() {
                return Builder.this.allowableValues;
            }

            @Override
            public String defaultValue() {
                return Builder.this.defaultValue;
            }

            @Override
            public String discriminatorProperty() {
                return Builder.this.discriminatorProperty;
            }

            @Override
            public DiscriminatorMapping[] discriminatorMapping() {
                return Builder.this.discriminatorMapping;
            }

            @Override
            public boolean hidden() {
                return Builder.this.hidden;
            }

            @Override
            public boolean enumAsRef() {
                return Builder.this.enumAsRef;
            }

            @Override
            public Class<?>[] subTypes() {
                return Builder.this.subTypes;
            }

            @Override
            public Extension[] extensions() {
                return Builder.this.extensions;
            }

            @Override
            public Class<?>[] prefixItems() {
                return Builder.this.prefixItems;
            }

            @Override
            public String[] types() {
                return Builder.this.types;
            }

            @Override
            public int exclusiveMaximumValue() {
                return Builder.this.exclusiveMaximumValue;
            }

            @Override
            public int exclusiveMinimumValue() {
                return Builder.this.exclusiveMinimumValue;
            }

            @Override
            public Class<?> contains() {
                return Builder.this.contains;
            }

            @Override
            public String $id() {
                return Builder.this.$id;
            }

            @Override
            public String $schema() {
                return Builder.this.$schema;
            }

            @Override
            public String $anchor() {
                return Builder.this.$anchor;
            }

            @Override
            public String $vocabulary() {
                return Builder.this.$vocabulary;
            }

            @Override
            public String $dynamicAnchor() {
                return Builder.this.$dynamicAnchor;
            }

            @Override
            public String $dynamicRef() {
                return Builder.this.$dynamicRef;
            }

            @Override
            public String contentEncoding() {
                return Builder.this.contentEncoding;
            }

            @Override
            public String contentMediaType() {
                return Builder.this.contentMediaType;
            }

            @Override
            public Class<?> contentSchema() {
                return Builder.this.contentSchema;
            }

            @Override
            public Class<?> propertyNames() {
                return Builder.this.propertyNames;
            }

            @Override
            public int maxContains() {
                return Builder.this.maxContains;
            }

            @Override
            public int minContains() {
                return Builder.this.minContains;
            }

            @Override
            public Class<?> additionalItems() {
                return Builder.this.additionalItems;
            }

            @Override
            public Class<?> unevaluatedItems() {
                return Builder.this.unevaluatedItems;
            }

            @Override
            public Class<?> _if() {
                return Builder.this._if;
            }

            @Override
            public Class<?> _else() {
                return Builder.this._else;
            }

            @Override
            public Class<?> then() {
                return Builder.this.then;
            }

            @Override
            public String $comment() {
                return Builder.this.$comment;
            }

            @Override
            public Class<?>[] exampleClasses() {
                return Builder.this.exampleClasses;
            }

            @Override
            public Schema.AdditionalPropertiesValue additionalProperties() {
                return Builder.this.additionalProperties;
            }

            @Override
            public DependentRequired[] dependentRequiredMap() {
                return Builder.this.dependentRequiredMap;
            }

            @Override
            public StringToClassMapItem[] dependentSchemas() {
                return Builder.this.dependentSchemas;
            }

            @Override
            public StringToClassMapItem[] patternProperties() {
                return Builder.this.patternProperties;
            }

            @Override
            public StringToClassMapItem[] properties() {
                return Builder.this.properties;
            }

            @Override
            public Class<?> unevaluatedProperties() {
                return Builder.this.unevaluatedProperties;
            }

            @Override
            public Class<?> additionalPropertiesSchema() {
                return Builder.this.additionalPropertiesSchema;
            }

            @Override
            public String[] examples() {
                return Builder.this.examples;
            }

            @Override
            public String _const() {
                return Builder.this._const;
            }

            @Override
            public Schema.SchemaResolution schemaResolution() {
                return Builder.this.schemaResolution;
            }
        };
    }
}

