/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.extractor;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springdoc.core.extractor.MethodParameterPojoExtractor;
import org.springdoc.core.service.AbstractRequestService;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestPart;

public class DelegatingMethodParameter
extends MethodParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingMethodParameter.class);
    private final MethodParameter delegate;
    private final Annotation[] additionalParameterAnnotations;
    private final String parameterName;
    private final boolean isParameterObject;
    private final Field field;
    private final Annotation[] methodAnnotations;
    private boolean isNotRequired;

    DelegatingMethodParameter(MethodParameter delegate, String parameterName, Annotation[] additionalParameterAnnotations, Annotation[] methodAnnotations, boolean isParameterObject, Field field, boolean isNotRequired) {
        super(delegate);
        this.delegate = delegate;
        this.field = field;
        this.additionalParameterAnnotations = additionalParameterAnnotations;
        this.parameterName = parameterName;
        this.isParameterObject = isParameterObject;
        this.isNotRequired = isNotRequired;
        this.methodAnnotations = methodAnnotations;
    }

    public static MethodParameter[] customize(String[] pNames, MethodParameter[] parameters, Optional<List<DelegatingMethodParameterCustomizer>> optionalDelegatingMethodParameterCustomizers, MethodParameterPojoExtractor methodParameterPojoExtractor, boolean defaultFlatParamObject) {
        ArrayList explodedParameters = new ArrayList();
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            MethodParameter p = parameters[i2];
            Class paramClass = AdditionalModelsConverter.getParameterObjectReplacement(p.getParameterType());
            boolean hasFlatAnnotation = p.hasParameterAnnotation(ParameterObject.class) || AnnotatedElementUtils.isAnnotated((AnnotatedElement)paramClass, ParameterObject.class);
            boolean hasNotFlatAnnotation = Arrays.stream(p.getParameterAnnotations()).anyMatch(annotation -> Arrays.asList(RequestBody.class, RequestPart.class).contains(annotation.annotationType()));
            if (!MethodParameterPojoExtractor.isSimpleType(paramClass) && (hasFlatAnnotation || defaultFlatParamObject && !hasNotFlatAnnotation && !AbstractRequestService.isRequestTypeToIgnore(paramClass))) {
                CopyOnWriteArrayList flatParams = new CopyOnWriteArrayList();
                methodParameterPojoExtractor.extractFrom(paramClass).forEach(flatParams::add);
                optionalDelegatingMethodParameterCustomizers.orElseGet(ArrayList::new).forEach(cz -> cz.customizeList(p, flatParams));
                explodedParameters.addAll(flatParams);
                continue;
            }
            String name = pNames != null ? pNames[i2] : p.getParameterName();
            explodedParameters.add(new DelegatingMethodParameter(p, name, null, null, false, null, false));
        }
        return explodedParameters.toArray(new MethodParameter[0]);
    }

    public static MethodParameter changeContainingClass(MethodParameter methodParameter, @Nullable Class<?> containingClass) {
        MethodParameter result = methodParameter.clone();
        try {
            Field containingClassField = FieldUtils.getDeclaredField(result.getClass(), "containingClass", true);
            containingClassField.set(result, containingClass);
            Field parameterTypeField = FieldUtils.getDeclaredField(result.getClass(), "parameterType", true);
            parameterTypeField.set(result, null);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn(e.getMessage());
        }
        return result;
    }

    @Override
    @NonNull
    public Annotation[] getParameterAnnotations() {
        Annotation[] allMethodAnnotations = ArrayUtils.addAll(this.delegate.getParameterAnnotations(), this.methodAnnotations);
        return ArrayUtils.addAll(allMethodAnnotations, this.additionalParameterAnnotations);
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public Method getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.delegate.getConstructor();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this.delegate.getMember();
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.delegate.getAnnotatedElement();
    }

    @Override
    public Executable getExecutable() {
        return this.delegate.getExecutable();
    }

    @Override
    public MethodParameter withContainingClass(Class<?> containingClass) {
        return this.delegate.withContainingClass(containingClass);
    }

    @Override
    public Class<?> getContainingClass() {
        return this.delegate.getContainingClass();
    }

    @Override
    public Class<?> getParameterType() {
        return this.delegate.getParameterType();
    }

    @Override
    public Type getGenericParameterType() {
        return this.delegate.getGenericParameterType();
    }

    @Override
    public Class<?> getNestedParameterType() {
        return this.delegate.getNestedParameterType();
    }

    @Override
    public Type getNestedGenericParameterType() {
        return this.delegate.getNestedGenericParameterType();
    }

    @Override
    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.delegate.initParameterNameDiscovery(parameterNameDiscoverer);
    }

    public boolean isNotRequired() {
        return this.isNotRequired;
    }

    public void setNotRequired(boolean notRequired) {
        this.isNotRequired = notRequired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DelegatingMethodParameter that = (DelegatingMethodParameter)o;
        return Objects.equals(this.delegate, that.delegate) && Arrays.equals(this.additionalParameterAnnotations, that.additionalParameterAnnotations) && Objects.equals(this.parameterName, that.parameterName);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.delegate, this.parameterName);
        result = 31 * result + Arrays.hashCode(this.additionalParameterAnnotations);
        return result;
    }

    public boolean isParameterObject() {
        return this.isParameterObject;
    }

    @Nullable
    public Field getField() {
        return this.field;
    }
}

