/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import com.hazelcast.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.hazelcast.shaded.com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.DelegatingMethodParameterCustomizer;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class ParameterObjectNamingStrategyCustomizer
implements DelegatingMethodParameterCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterObjectNamingStrategyCustomizer.class);

    @Override
    public void customize(MethodParameter originalParameter, MethodParameter methodParameter) {
        JsonNaming jsonNaming;
        if (AnnotatedElementUtils.isAnnotated(methodParameter.getContainingClass(), JsonNaming.class) && (jsonNaming = methodParameter.getContainingClass().getAnnotation(JsonNaming.class)).value().equals(PropertyNamingStrategies.UpperSnakeCaseStrategy.class)) {
            try {
                Field parameterNameField = FieldUtils.getDeclaredField(methodParameter.getClass(), "parameterName", true);
                parameterNameField.set(methodParameter, PropertyNamingStrategies.UpperSnakeCaseStrategy.INSTANCE.translate(methodParameter.getParameterName()));
            }
            catch (IllegalAccessException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

