/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.customizers;

import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.GlobalOperationComponentsCustomizer;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.utils.SpringDocUtils;
import org.springframework.boot.actuate.endpoint.ApiVersion;
import org.springframework.boot.actuate.endpoint.SecurityContext;
import org.springframework.boot.actuate.endpoint.annotation.AbstractDiscoveredOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.invoke.OperationParameter;
import org.springframework.boot.actuate.endpoint.invoke.reflect.OperationMethod;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;

public class ActuatorOperationCustomizer
implements GlobalOperationComponentsCustomizer {
    private static final String OPERATION = "operation";
    private static final String PARAMETER = "parameter";
    private static final Logger LOGGER = LoggerFactory.getLogger(ActuatorOperationCustomizer.class);
    private final SpringDocConfigProperties springDocConfigProperties;

    public ActuatorOperationCustomizer(SpringDocConfigProperties springDocConfigProperties) {
        this.springDocConfigProperties = springDocConfigProperties;
    }

    @Override
    public Operation customize(Operation operation, Components components, HandlerMethod handlerMethod) {
        if (this.operationHasValidTag(operation)) {
            Field operationField = FieldUtils.getDeclaredField(handlerMethod.getBean().getClass(), OPERATION, true);
            if (operationField != null) {
                this.processOperationField(handlerMethod, operation, components, operationField);
            }
            this.setOperationSummary(operation, handlerMethod);
        }
        return operation;
    }

    private boolean operationHasValidTag(Operation operation) {
        return operation.getTags() != null && operation.getTags().contains(ActuatorProvider.getTag().getName());
    }

    private void processOperationField(HandlerMethod handlerMethod, Operation operation, Components components, Field operationField) {
        try {
            Object actuatorOperation = operationField.get(handlerMethod.getBean());
            Field actuatorOperationField = FieldUtils.getDeclaredField(actuatorOperation.getClass(), OPERATION, true);
            if (actuatorOperationField != null) {
                AbstractDiscoveredOperation discoveredOperation = (AbstractDiscoveredOperation)actuatorOperationField.get(actuatorOperation);
                this.handleOperationMethod(discoveredOperation.getOperationMethod(), components, operation);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    private void handleOperationMethod(OperationMethod operationMethod, Components components, Operation operation) {
        String operationId = operationMethod.getMethod().getName();
        operation.setOperationId(operationId);
        switch (operationMethod.getOperationType()) {
            case READ: {
                this.addParameters(operationMethod, operation, components, ParameterIn.QUERY);
                break;
            }
            case WRITE: {
                this.addWriteParameters(operationMethod, components, operation);
                operation.setResponses(new ApiResponses().addApiResponse(String.valueOf(HttpStatus.NO_CONTENT.value()), new ApiResponse().description(HttpStatus.NO_CONTENT.getReasonPhrase())).addApiResponse(String.valueOf(HttpStatus.BAD_REQUEST.value()), new ApiResponse().description(HttpStatus.BAD_REQUEST.getReasonPhrase())));
                break;
            }
            case DELETE: {
                operation.setResponses(new ApiResponses().addApiResponse(String.valueOf(HttpStatus.NO_CONTENT.value()), new ApiResponse().description(HttpStatus.NO_CONTENT.getReasonPhrase())));
                this.addParameters(operationMethod, operation, components, ParameterIn.QUERY);
                break;
            }
        }
    }

    private void addParameters(OperationMethod operationMethod, Operation operation, Components components, ParameterIn parameterIn) {
        for (OperationParameter operationParameter : operationMethod.getParameters()) {
            java.lang.reflect.Parameter parameter = this.getParameterFromField(operationParameter);
            if (parameter == null) continue;
            Schema<?> schema = this.resolveSchema(parameter, components);
            if (parameter.getAnnotation(Selector.class) != null) {
                operation.addParametersItem(new PathParameter().name(parameter.getName()).schema(schema));
                operation.getResponses().addApiResponse(String.valueOf(HttpStatus.NOT_FOUND.value()), new ApiResponse().description(HttpStatus.NOT_FOUND.getReasonPhrase()));
                continue;
            }
            if (!this.isValidParameterType(parameter)) continue;
            operation.addParametersItem(new Parameter().name(parameter.getName()).in(parameterIn.toString()).schema(schema));
        }
    }

    private void addWriteParameters(OperationMethod operationMethod, Components components, Operation operation) {
        for (OperationParameter operationParameter : operationMethod.getParameters()) {
            java.lang.reflect.Parameter parameter = this.getParameterFromField(operationParameter);
            if (parameter == null) continue;
            Schema<?> schema = this.resolveSchema(parameter, components);
            if (parameter.getAnnotation(Selector.class) != null) {
                operation.addParametersItem(new PathParameter().name(parameter.getName()).schema(schema));
                continue;
            }
            operation.setRequestBody(new RequestBody().content(new Content().addMediaType("application/json", new MediaType().schema(schema))));
        }
    }

    private java.lang.reflect.Parameter getParameterFromField(OperationParameter operationParameter) {
        try {
            return (java.lang.reflect.Parameter)FieldUtils.readDeclaredField(operationParameter, PARAMETER, true);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn(e.getMessage());
            return null;
        }
    }

    private Schema<?> resolveSchema(java.lang.reflect.Parameter parameter, Components components) {
        Schema schema = AnnotationsUtils.resolveSchemaFromType(parameter.getType(), components, null, this.springDocConfigProperties.isOpenapi31());
        if (this.springDocConfigProperties.isOpenapi31()) {
            SpringDocUtils.handleSchemaTypes(schema);
        }
        return schema;
    }

    private boolean isValidParameterType(java.lang.reflect.Parameter parameter) {
        return !ApiVersion.class.isAssignableFrom(parameter.getType()) && !WebServerNamespace.class.isAssignableFrom(parameter.getType()) && !SecurityContext.class.isAssignableFrom(parameter.getType());
    }

    private void setOperationSummary(Operation operation, HandlerMethod handlerMethod) {
        String summary = handlerMethod.toString();
        if (operation.getSummary() == null && !summary.contains("$")) {
            operation.setSummary(summary);
        }
    }

    @Override
    public Operation customize(Operation operation, HandlerMethod handlerMethod) {
        return this.customize(operation, null, handlerMethod);
    }
}

